MobyleJob = Class.create();
MobyleJob.prototype = Object.extend({

    cgiurl:'job_status.py',

    initAjaxParams: function() {
      try{
        this.el=this.otherparams.get('el');
        this.jobid = this.cgiparams.get('jobid');
        this.parameters.set('_action','getHTML');
      }catch(err){
        reportMobyleError(err);
      }
    },
    
    onCompleteFunction: function() {
      try{
        this.programName = $(this.jobid + '_programName').value; 
        this.initResultBoxes();
        Object.extend(this, new MobyleHelpPopUps(this.jobid));
        // reload job data from server only if the job status has changed
        if(this.jobInfo && this.jobInfo['status']!=null && this.jobInfo['status'] !=$(this.jobid + '_status').value){
          portal.jobs.build();
        }
        this.jobInfo = new Object();
        this.jobInfo['id'] = this.jobid;
        this.jobInfo['date'] = $(this.jobid + '_date').value;
        this.jobInfo['status'] = $(this.jobid + '_status').value;
        this.jobInfo['errormsg'] = $(this.jobid + '_message').value;
        // ask help popups
        this.showAskHelpButton();
        // remove job popups
        this.initRemoveJobButton();
        // go back to the form button
        Event.observe('backtoform_' + this.popUpName, 'click', 
          function(e){
			$('services_tabPanel').getFormTab(this.programName);
            Event.stop(e);
        }.bindAsEventListener(this));
		// update tab handle label
		if($(this.jobid+'_tabHandle')){
		  $(this.jobid+'_tabHandle').innerHTML = this.programName +" - " + this.jobInfo['date'];
		}
      }catch(err){
        reportMobyleError(err);
      }
    },
    
    initRemoveJobButton: function(){
      try{
        Element.show('jobremovaldisplay_'+this.popUpName);
        $('jobremovaldisplay_'+this.popUpName).onclick = this.displayJobRemovalForm.bindAsEventListener(this);
      }catch(err){
        reportMobyleError(err);
      }      
    },
    
    displayJobRemovalForm: function(){
      try{
        Element.show(this.popUpName + "PopupOverlay");
        Element.show(this.popUpName + "JobRemovalConfirmPopup");
        $(this.popUpName + "JobRemovalConfirmSubmit").onclick = function(){
            this.p = new Object();
            this.p['id'] = this.jobid;
            new Ajax.Request('job_remove.py',
            {
              method:'post',
              postBody: $H(this.p).toQueryString(),
              onCreate: function(){
                // switch to waiting screen
                Element.hide(this.popUpName + "JobRemovalConfirmPopup");
                Element.show(this.popUpName + "JobRemovalWaitPopup");        
              }.bind(this),
              onSuccess: function(transport){
                // close job tab
				$(this.jobid+'_tabHandle').removeTab();
              }.bind(this),            
              onComplete: function(){
                // reload user data
                portal.data.build();
                portal.jobs.build();
              }.bind(this),
              onFailure: function(){
                // if removal failed, close the waiting screen anyway
                Element.hide(this.popUpName + "JobRemovalWaitPopup");                      
                Element.hide(this.popUpName + "PopupOverlay");
              }.bind(this)
            });      
        }.bindAsEventListener(this);
        $(this.popUpName + "JobRemovalConfirmCancel").onclick = function(){
          Element.hide(this.popUpName + "PopupOverlay");
          Element.hide(this.popUpName + "JobRemovalConfirmPopup");          
        }.bind(this);
      }catch(err){
        reportMobyleError(err);
      }      
    },    
    
    initResultBoxes: function() {
      try{
        this.el.select(".results_file").each(
          function(element){
            var parameterName = element.select('.parameterName')[0].value;
            var fileName = element.select('.fileName')[0].value;
            var resultId = element.select('.resultId')[0].value;
            if (element.select('.parameterDataType').size()>0){
              var dataType = element.select('.parameterDataType')[0].value;
            }else{
              var dataType = null
            }
            if (element.select('.parameterBioType').size()>0){
              var bioTypes = element.select('.parameterBioType').pluck('value');
            }else{
              var bioTypes = null
            }
            if (element.select('.parameterCard').size()>0){
              var card = element.select('.parameterCard')[0].value;
            }else{
              var card = null
            }            
            new MobyleResultBox(element, this, this.programName, parameterName, fileName, resultId, dataType, bioTypes, card);
          }.bind(this)
        );
      }catch(err){
        reportMobyleError(err);
      }
    }
  
},MobyleWidget.prototype);

MobyleResultBox = Class.create();
MobyleResultBox.prototype = Object.extend({
 
    initialize: function(el, job, programName, parameterName, fileName, resultId, dataType, bioTypes, card) {
      try{
        this.el=el;
        this.inputField = new MobyleInputField(this.el);
        this.job = job;
        this.jobId = job.id;
        this.programName = programName;
        this.parameterName = parameterName;
        this.fileName = fileName;
        this.resultId = resultId;
        this.dataType = dataType;
        this.bioTypes = bioTypes;
        this.card = card;
        this.maxCard = this.card.charAt(this.card.length-1);
        this.selectEl = this.el.select(".pipeselect").first();
        pipesSortFunction = function(pipe){
          return pipe.id;
        }
        var rb = this;
        this.pipeLinkEl = this.el.select(".piperesultlink").first();
        var onPipesBuiltFunction = function(){
          // enable the pipe button only if program pipes are available
          if(this.data.size()==0){
            rb.selectEl.up().hide();
          }else{
            rb.selectEl.up().show();
          }
        };
        this.dataSelectPipes = new MobyleJSONSelect(this.selectEl, this.pipeFilter.bind(this), '#{id}', '#{servicePrompt} - #{parameterPrompt}', '#{program} (#{parameterName})', portal.inputs, undefined, pipesSortFunction, onPipesBuiltFunction);        
        this.saveLinkEl = this.el.select(".saveresultlink").first();
        if(this.pipeLinkEl){
          this.pipeLinkEl.onclick = this.pipe.bindAsEventListener(this);
        }        
        this.saveLinkEl.onclick = this.save.bindAsEventListener(this);
      }catch(err){
        reportMobyleError(err);
      }
    },
    
    pipeFilter: function(input){
      try{
        if(input.dataType==this.dataType){ // datatype filter
          // we do not take cardinalities into account, given the lack of data cardinality management for now in Mobyle
          //if(input.maxCard>=this.maxCard || input.maxCard=='n'){ // maximal cardinality filter
            if(this.bioTypes==null || input.bioTypes==null
            || this.bioTypes.size()==0 || input.bioTypes.size()==0
            || this.bioTypes.findAll(function(bt){if(input.bioTypes.include(bt)) return bt;}).size()>0 )
            {
              return true;
            }
          //}
        }
        return false;
      }catch(err){
        reportMobyleError(err);
      }
    },
    
    pipe: function(){
      try{
        if(!$F(this.selectEl).blank()){
          this.pipe = $F(this.selectEl).split("|");
          this.pipeInputProgram = this.pipe[0];
          this.pipeInputParameter = this.pipe[1];
          this.addResult(this.pipeCallback); // save function creates a pipe in the callback if pipe flag is activated
        }
      }catch(err){
        reportMobyleError(err);
      }
    },
    
    save: function(){
      this.addResult(this.saveCallback);
    },
    
    addResult: function(onSuccessFunction){
      try{
        this.inputField.removeInvalidFieldMessage();
        Form.Element.disable(this.pipeLinkEl);
        Form.Element.disable(this.saveLinkEl);
        this.onSuccessFunction = onSuccessFunction;
        this.p = new Object();
        this.p.fileName = this.fileName;
        this.p.parameterName = this.parameterName;
        if(!$F(this.resultId).blank()){
          this.p.newFileName = $F(this.resultId);
        }
        this.p.jobId = this.job.jobid;
        new Ajax.Request('data_bookmark.py',
        {
          method:'post',
          postBody: $H(this.p).toQueryString(),
          onSuccess: function(transport){
            result = transport.responseText.evalJSON();
            if(result.errormsg){
              this.inputField.setInvalidFieldMessage(result.errormsg);
            }else{
              this.onSuccessFunction(result.safeFileName);
            }
          }.bind(this),
          onComplete: function(){
            this.onSuccessFunction = null;
            Form.Element.enable(this.pipeLinkEl);
            Form.Element.enable(this.saveLinkEl);            
          }.bind(this)
        });    
      }catch(err){
        alert(err);
        alert(Object.inspect(this.saveLinkEl));
        reportMobyleError(err);
      }
    },
    
    saveCallback: function(){
      try{
        this.pipeLinkEl.enable();        
        this.saveLinkEl.enable();        
        portal.data.build();
      }catch(err){
        reportMobyleError(err);
      }
    },
    
    pipeCallback: function(safeFileName){
      try{
        this.pipeLinkEl.enable();        
        this.saveLinkEl.enable();        
        this.safeFileName = safeFileName;
        portal.data.build(this.filesListBuildCallBack, this);
      }catch(err){
        reportMobyleError(err);
      }
    },

    filesListBuildCallBack: function(object){
      try{
	  	$('services_tabPanel').getFormTab(object.pipeInputProgram,object.pipeInputParameter,object.safeFileName);
      }catch(err){
        reportMobyleError(err);
      }
    }

});