/**
 * @class MobyleRegistrationForm is a class that initializes 
 * AJAX behaviour for the registration form of the portal
 *
 * @author Herv Mnager
 * @organization Pasteur Institute
 * @contact mobyle@pasteur.fr
 */
MobyleRegistrationForm = Class.create();

MobyleRegistrationForm.prototype = {

    initialize: function() {
      try{
        this.rEmailEl = new MobyleInputField($('register_email'));
        this.rPasswEl = new MobyleInputField($('register_password'));
        this.rPasswCEl = new MobyleInputField($('register_password_check'));
        this.rEmailEl.el = this.rEmailEl.msgEl;
        this.rPasswEl.el = this.rPasswEl.msgEl;
        this.rPasswCEl.el = this.rPasswCEl.msgEl;
        $('register_submit').onclick = this.submitRegistrationRequest.bindAsEventListener(this);
      }catch(err){
        reportMobyleError(err);
      }
    },
      
    submitRegistrationRequest: function() {
      try{
        if(this.rPasswEl.el.value!=this.rPasswCEl.el.value){
          this.rPasswEl.setInvalidFieldMessage("The password values you entered need to be identical");
        }else{
          var rf = this;
          this.p = new Object();
          this.p['email']=this.rEmailEl.el.value;
          this.p['password']=this.rPasswEl.el.value;
          new Ajax.Request('session_register.py',
          {
            method:'post',
            postBody: $H(this.p).toQueryString(),
            onSuccess: function(transport){
              // we get a json response, that is parsed to create the job's menu entry
                try{
				  portal.loadSessionInfoFromCookie();
                  var answer = transport.responseText.evalJSON();
                  if(answer.accountOk=="True"){
                    portal.reload();
                  }else{
                    rf.rEmailEl.setInvalidFieldMessage(answer.msg);
                  }
                }catch(err){
                  reportMobyleError(err);
                }
              },
            onComplete: function(){
            }
          });
        }
      }catch(err){
        reportMobyleError(err);
      }
    }
    
}


/**
 * @class MobyleSignInForm is a class that initializes 
 * AJAX behaviour for the sign-in form of the portal
 *
 * @author Herv Mnager
 * @organization Pasteur Institute
 * @contact mobyle@pasteur.fr
 */
MobyleSignInForm = Class.create();

MobyleSignInForm.prototype = {

    initialize: function() {
      try{
        this.sEmailEl = new MobyleInputField($('signin_email'));
        this.sPasswEl = new MobyleInputField($('signin_password'));
        this.sEmailEl.el = this.sEmailEl.msgEl;
        this.sPasswEl.el = this.sPasswEl.msgEl;
        $('signin_submit').onclick = this.submitSignInRequest.bindAsEventListener(this);
      }catch(err){
        reportMobyleError(err);
      }
    },
  
    submitSignInRequest: function() {
      try{
        var sf = this;
        this.p = new Object();
        this.p['email']=this.sEmailEl.el.value;
        this.p['password']=this.sPasswEl.el.value;
        new Ajax.Request('session_signin.py',
        {
          method:'post',
          postBody: $H(this.p).toQueryString(),
          onSuccess: function(transport){
            // we get a json response, that is parsed to create the job's menu entry
              try{
				portal.loadSessionInfoFromCookie();
                var answer = transport.responseText.evalJSON();
                if(answer.accountOk=="True"){
                  portal.reload();
                }else{
                  sf.sEmailEl.setInvalidFieldMessage(answer.msg);
                }
              }catch(err){
                reportMobyleError(err);
              }
            }.bind(this),
          onComplete: function(){
          }
        });
      }catch(err){
        reportMobyleError(err);
      }
    }
    
}

/**
 * @class MobyleSignOffLink is a class that initializes 
 * AJAX behaviour for the sign-off link of the portal
 *
 * @author Herv Mnager
 * @organization Pasteur Institute
 * @contact mobyle@pasteur.fr
 */
MobyleSignOffLink = Class.create();

MobyleSignOffLink.prototype = {

    initialize: function() {
      try{
        $('signoff_submit').onclick = this.submitSignOffRequest.bindAsEventListener(this);
      }catch(err){
        reportMobyleError(err);
      }
    },
    
    submitSignOffRequest: function() {
      try{
        var sl = this;
        new Ajax.Request('session_signoff.py',
        {
          method:'post',
          onSuccess: function(transport){
            // we get a json response, that is parsed to create the job's menu entry
              try{
			    portal.loadSessionInfoFromCookie();
                var answer = transport.responseText.evalJSON();
                if(answer.accountOk=="True"){
                  portal.reload();
                  //portal.loadSessionInfoFromCookie();
                }else{
                  sf.sEmailEl.setInvalidFieldMessage(answer.msg);
                }
              }catch(err){
                reportMobyleError(err);
              }
            },
          onComplete: function(){
          }
        });
      }catch(err){
        reportMobyleError(err);
      }
    }
    
}

/**
 * @class MobyleSignInForm is a class that initializes 
 * AJAX behaviour for the sign-in form of the portal
 *
 * @author Herv Mnager
 * @organization Pasteur Institute
 * @contact mobyle@pasteur.fr
 */
MobyleActKeyForm = Class.create();

MobyleActKeyForm.prototype = {

    initialize: function() {
      try{
        this.sEmailEl = new MobyleInputField($('actkey_email'));
        this.sPasswEl = new MobyleInputField($('actkey_password'));
        this.sKeywEl = new MobyleInputField($('actkey_key'));
        this.sEmailEl.el = this.sEmailEl.msgEl;
        this.sPasswEl.el = this.sPasswEl.msgEl;
        this.sKeywEl.el = this.sKeywEl.msgEl;
        this.sEmailEl.el.value = portal.email;
        this.sPasswEl.el.value = portal.password;
        $('actkey_submit').onclick = this.submitActKeyRequest.bindAsEventListener(this);
      }catch(err){
        reportMobyleError(err);
      }
    },
      
    submitActKeyRequest: function() {
      try{
        var sf = this;
        this.p = new Object();
        this.p['email']=this.sEmailEl.el.value;
        this.p['password']=this.sPasswEl.el.value;
        this.p['actkey']=this.sKeywEl.el.value;
        new Ajax.Request('session_activate.py',
        {
          method:'post',
          postBody: $H(this.p).toQueryString(),
          onSuccess: function(transport){
            // we get a json response, that is parsed to create the job's menu entry
              try{
				portal.loadSessionInfoFromCookie();
                var answer = transport.responseText.evalJSON();
                if(answer.accountOk=="True"){
                  portal.reload();
                }else{
                  sf.sEmailEl.setInvalidFieldMessage(answer.msg);
                }
              }catch(err){
                reportMobyleError(err);
              }
            },
          onComplete: function(){
          }
        });
      }catch(err){
        reportMobyleError(err);
      }
    }
    
}