MobyleToolTipManager = Class.create();
MobyleToolTipManager.prototype = {
    
    initialize: function() {
      try{
        this.initializeBehaviour();   
      }catch(err){
        reportMobyleError(err);
      }
    },
  
    initializeBehaviour: function(el) {
        try{
          Event.observe(document.body, 'mouseover', function(event) {
            var element = Event.element(event);
            // if a tooltip exists for this program, hide it and show it only when mouse is over it
            if(element && typeof element.next == "function" && element.next() && element.next().hasClassName('tooltip')){
              var tooltipEl = element.next();
              this.showTooltip(this, tooltipEl);
              element.onmouseover = this.showTooltip.bindAsEventListener(this, tooltipEl);
              element.onmouseout = this.hideTooltip.bindAsEventListener(this, tooltipEl, element);
              tooltipEl.onmouseout = this.hideTooltip.bindAsEventListener(this, tooltipEl, element);
              element.onmousemove = this.moveTooltip.bindAsEventListener(this, tooltipEl);
              tooltipEl.onclick = element.onclick;
            }
          }.bind(this));
        }catch(err){
          reportMobyleError(err);
        }
    },

    showTooltip: function(e, tooltipEl){
      try{
        if(this.timeOutTooltipId){
          clearTimeout(this.timeOutTooltipId);
        }
        this.timeOutTooltipId=setTimeout((function() {Element.show(tooltipEl)}).bind(this), 500);
      }catch(err){
        reportMobyleError(err);
      }
    },

    hideTooltip: function(e, tooltipEl, element){
      try{
        if(e.relatedTarget!=tooltipEl && e.relatedTarget!=element){ // do not accept this event if we leave to enter the tooltip element
          if(this.timeOutTooltipId){
            clearTimeout(this.timeOutTooltipId);
          }
          Element.hide(tooltipEl);
        }
      }catch(err){
        reportMobyleError(err);
      }
    },

    moveTooltip: function(e, tooltipEl){
      try{
        Element.setStyle(tooltipEl, {
          position:"absolute",
          top:(Event.pointerY(e) - e.currentTarget.offsetParent.offsetTop) + "px",
          left:(Event.pointerX(e) - e.currentTarget.offsetParent.offsetLeft) + "px"
        });
      }catch(err){
        reportMobyleError(err);
      }
    }
}


