MobyleWidget = Class.create();
MobyleWidget.prototype = {

  // need to be defined
  // this.el
  // this.cgiurl
  // this.parameters
  // this.onCompleteFunction
  // this.insertion

  initialize: function(cgiparams, otherparams) {
    try{
      // set default value for parameters, in case it is not specified
      this.parameters = $H();
      this.cgiparams = cgiparams;
      this.otherparams = otherparams;
      this.initAjaxParams();
      this.buildFlag = false;
      this.build();
    }catch(err){
      reportMobyleError(err);
    }
  },

  // load the widget from its cgi.
  //  -the optional parameter onCompletedFunction specifies an additional function launched
  //  once the widget has been built.
  //  -the onCompletedThisObject object helps keeping the context
  build: function(onCompletedFunction, oncCompletedThisObject) {
    try{
      if(!this.buildFlag){ // builFlag is set to true when calling the build function, and avoids concurrent calls to a cgi for the same widget.
        this.buildFlag = true;
        this.parameters.set('isInPortal','true'); // when called using Ajax, the CGI is always in the portal...
        var cgipar = this.parameters.merge($H(this.cgiparams));
        new Ajax.Updater(this.el, 
          this.cgiurl, 
          {
            method: 'post', 
            postBody: cgipar.toQueryString(), 
            onComplete: function(){
              try{
			  	this.el = $(this.el);
                this.buildFlag = false;
                this.el.select(".refresh_link").each(
                  function(el){
                    el.onclick = this.build.bindAsEventListener(this);                
                  }.bind(this)
                );
                this.onCompleteFunction();
                $(this.el).removeClassName('loading');              
              }catch(err){
                reportMobyleError(err);
              }  
            }.bind(this),
            onLoading: function(){
              try{
                $(this.el).addClassName('loading');
              }catch(err){
                reportMobyleError(err);
              }  
            }.bind(this)
          }    
        );
      }
    }catch(err){
      reportMobyleError(err);
    }
  }
    
}