// Title: Tigra Tree
// Description: See the demo at url
// URL: http://www.softcomplex.com/products/tigra_menu_tree/
// Version: 1.1
// Date: 11-12-2002 (mm-dd-yyyy)
// Notes: This script is free. Visit official site for further details.

// TODO: tree_add/tree_remove for dynamic queries

function tree (a_items, a_template, a_id, datainput_type) {
	this.datainput_type = datainput_type;
	this.a_tpl      = a_template;
	this.a_config   = a_items;
	this.o_root     = this;
	this.a_index    = [];
	this.o_selected = null;
	this.n_depth    = -1;
	this.a_id = a_id;
	this.a_div = document.getElementById(a_id);
	this.items = $H(); // tree items dictionnary, containing the js objects mapped by their IDs

	var o_icone = new Image(),
		o_iconl = new Image();
	o_icone.src = a_template['icon_e'];
	o_iconl.src = a_template['icon_l'];
	a_template['im_e'] = o_icone;
	a_template['im_l'] = o_iconl;
	for (var i = 0; i < 64; i++)
		if (a_template['icon_' + i]) {
			var o_icon = new Image();
			a_template['im_' + i] = o_icon;
			o_icon.src = a_template['icon_' + i];
		}
	
	this.toggle = function (n_id) {debug_msg("toggle");	var o_item = this.a_index[n_id]; o_item.open(); debug_msg("opening "+ o_item.htmlID);};
	this.select = function (n_id) {return this.a_index[n_id].select(); };
	this.mout   = function (n_id) { this.a_index[n_id].upstatus(true) };
	this.mover  = function (n_id) { this.a_index[n_id].upstatus() };

	this.a_children = [];
	for (var i = 0; i < a_items.length; i++) {
		var item = new tree_item(this, i);
		this.items[item.htmlID] = item;
	}

	this.n_id = trees.length;
	trees[this.n_id] = this;
	var _child = document.createElement('span');
	for (var i = 0; i < this.a_children.length; i++) {
		_child.innerHTML += this.a_children[i].init();
	}
	this.a_div.appendChild(_child);
	for (var i = 0; i < this.a_children.length; i++) {
		this.a_children[i].open();
	}

}

function tree_item (o_parent, n_order) {
	this.n_depth  = o_parent.n_depth + 1;
	this.a_config = o_parent.a_config[n_order + (this.n_depth ? 2 : 0)];
	if (!this.a_config) return;

	this.htmlID = 'programLink_' + this.a_config[0];
	this.o_root    = o_parent.o_root;
	this.o_parent  = o_parent;
	this.n_order   = n_order;
	this.b_opened  = false;  // b_opened is a flag set to true if the tree item is visible

	this.n_id = this.o_root.a_index.length;
	this.o_root.a_index[this.n_id] = this;
	o_parent.a_children[n_order] = this;

	this.a_children = [];
	for (var i = 0; i < this.a_config.length - 2; i++) {
		var item = new tree_item(this, i);
		this.o_root.items[item.htmlID] = item;
    }

	this.get_icon = item_get_icon;
	this.open     = item_open;
	if(this.a_children.length==0){
		this.select   = item_select;
	}else{
		this.select   = item_open;
	}	
	this.init     = item_init;
	this.upstatus = item_upstatus;
	this.is_last  = function () { return this.n_order == this.o_parent.a_children.length - 1 };
}

function item_open () {
	try{
		var b_close = !this.b_opened;
		var o_idiv = get_element('i_div' + this.o_root.n_id + '_' + this.n_id);
		if (!o_idiv) return;
				
		if (!o_idiv.innerHTML) {
			var a_children = [];
			for (var i = 0; i < this.a_children.length; i++){
				a_children[i]= this.a_children[i].init();
				}
				o_idiv.innerHTML = a_children.join('');
		}
		o_idiv.style.display = (b_close ? 'none' : 'block');
		
		var o_jicon = document.images['j_img' + this.o_root.n_id + '_' + this.n_id],
			o_iicon = document.images['i_img' + this.o_root.n_id + '_' + this.n_id];
		if (o_jicon) o_jicon.src = this.get_icon(true);
		if (o_iicon) o_iicon.src = this.get_icon();
		this.upstatus();
		this.b_opened = b_close;
	}catch(err){
		debug_msg("error during item_open : "+err);
	}
}

function item_select (b_deselect) {
	/* totally modified by C. Letondal 2005/8/25 */
	// this.a_config contains, for a program, its descr and his name in an array like this: [descr,name]	
	var program = new String(this.a_config[0]);
	try{
		services.loadProgram(program,datainput_type[program]);
		tabs.closeAll();
		tabs[datainput_type[program]].open();
	}catch(err){
		debug_msg(err);
	}
	return(true);
}

function item_upstatus (b_clear) {
	window.setTimeout('window.status="' + (b_clear ? '' : this.a_config[0] + (this.a_config[1] ? ' ('+ this.a_config[1] + ')' : '')) + '"', 10);
}

function item_init () {

	var a_offset = [],
		o_current_item = this.o_parent;
	for (var i = this.n_depth; i > 1; i--) {
		a_offset[i] = '<img src="' + this.o_root.a_tpl[o_current_item.is_last() ? 'icon_e' : 'icon_l'] + '" border="0" align="absbottom">';
		o_current_item = o_current_item.o_parent;
	}

	// C. Letondal version -- explicit tests + string concatenation
	var result2 = '<table cellpadding="0" cellspacing="0" border="0"><tr><td nowrap>';
	if (this.n_depth ) {
	   result2 += a_offset.join('');
	   if (this.a_children.length) {
	      result2 += '<a href="javascript: trees[' + this.o_root.n_id + '].toggle(' + this.n_id + ')" onmouseover="trees[' + this.o_root.n_id + '].mover(' + this.n_id + ')" onmouseout="trees[' + this.o_root.n_id + '].mout(' + this.n_id + ')"><img src="' + this.get_icon(true) + '" border="0" align="absbottom" name="j_img' + this.o_root.n_id + '_' + this.n_id + '"></a>';
	   } else {
	      result2 += '<img src="' + this.get_icon(true) + '" border="0" align="absbottom">';
	   }
	}
	result2 += '<a href="#" class="program_menu_item" id="'+ this.htmlID +'"onclick="trees[' + this.o_root.n_id + '].select(' + this.n_id + ')" ondblclick="trees[' + this.o_root.n_id + '].toggle(' + this.n_id + ')" onmouseover="trees[' + this.o_root.n_id + '].mover(' + this.n_id + ')" onmouseout="trees[' + this.o_root.n_id + '].mout(' + this.n_id + ')" ><img src="' + this.get_icon() + '" border="0" align="absbottom" name="i_img' + this.o_root.n_id + '_' + this.n_id + '" class="t' + this.o_root.n_id + 'im">' + this.a_config[1] + '</a></td></tr></table>';
	if (this.a_children.length) {
	   result2 += '<div id="i_div' + this.o_root.n_id + '_' + this.n_id + '"></div>';
	}
	this.b_opened  = true;
	this.showItem = function() {this.o_root.toggle(this.o_parent.n_id);alert(this.innerHTML);};
	return result2;
	
}

function item_get_icon (b_junction) {
	return this.o_root.a_tpl['icon_' + ((this.n_depth ? 0 : 32) + (this.a_children.length ? 16 : 0) + (this.a_children.length && this.b_opened ? 8 : 0) + (!b_junction && this.o_root.o_selected == this ? 4 : 0) + (b_junction ? 2 : 0) + (b_junction && this.is_last() ? 1 : 0))];
}


var trees = [];
get_element = document.all ?
	function (s_id) { return document.all[s_id] } :
	function (s_id) { return document.getElementById(s_id) };
