import sys, time, signal
import getopt
import os
import subprocess


import Mobyle.ConfigManager
import Mobyle.Utils

#======================================
#
#   JOBW  CLASS:
#
#======================================


class JOBW:
    def __init__( self, jobNames = [], jobKeys = [], emails = [], remotes=[], sessions=[] ):
        """
        Print informations ( Batch, Date, Email, JobName, Queue, Remote, Status,
        Session) of running services.
        """

        self.config = Mobyle.ConfigManager.Config()

        self.diplay = {'date':True, 'batch':True, 'number':True,
                       'email':True, 'jobname':True, 'jobkey':True,
                       'queue':True, 'session': True,
                       'status':True, 'remote':True,
                       'session': True , 'command': True}

        self.queueKey = None
        #self.queueMax ={'ext':20, 'ipom':20, 'long':4, 'local':30,
        #                'small':5, 'noonan':1}

        self.queueMax = {'local': 100000, 'short': 100000 }

        self.sortKey = 'Date'

        self.keysAssociation= {'1':'Date', '2':'Email', '3':'Remote',
                              '4':'JobName', '5':'Batch', '6':'Queue',
                              '7':'Status',  '8': 'Session'
                               }

        self.admins = self.getAdmins( jobNameToDisplay = map(lambda x: x.strip(), jobNames),
                                      jobKeyToDisplay = map(lambda x: x.strip(), jobKeys),
                                      emailsToDisplay = map(lambda x: x.strip(), emails),
                                      remotesToDisplay = map(lambda x: x.strip(), remotes),
                                      sessionsToDisplay = map(lambda x: x.strip(), sessions))

    def getAdmins( self, jobNameToDisplay = [], jobKeyToDisplay = [], emailsToDisplay = [],  remotesToDisplay = [], sessionsToDisplay = [] ):
        """
        Return list of Admin Object --> list
        """
        admindir_path = os.path.join( self.config.results_path(), 'ADMINDIR')

        admins = []
        list = []

        if jobNameToDisplay:
            # Proceed only jobName specified in jobNameToDisplay
            for job in os.listdir( admindir_path ):
                fields = job.split('.')
                if fields[0] in jobNameToDisplay:
                    list.append( job )
        else:
            # Proceed all file from the ADMINDIR directory
            list = os.listdir( admindir_path )

        if jobKeyToDisplay:
            # Proceed only jobKey specified in jobKeyToDisplay
            list2 = []
            for job in list:
                fields = job.split('.')
                if fields[1] in jobKeyToDisplay:
                    list2.append( job )
            list = list2

        for jobName in list:
            try:
                adm_path = os.path.join( admindir_path , jobName )
                admin = Mobyle.Utils.Admin( adm_path )
                if emailsToDisplay:
                    if admin.getEmail() in emailsToDisplay:
                        admins.append( admin )
                if remotesToDisplay:
                    if admin.getRemote().split('\\')[0] in remotesToDisplay:
                        admins.append( admin )
                if sessionsToDisplay:
                    if admin.getSession() in sessionsToDisplay:
                        admins.append( admin )
                else:
                    admins.append( admin )
            except IOError, err:
                print >>sys.stderr,  "%s" % ( err )
                continue
        return admins


    ### Statistics over bioweb queue
    def queueStat( self ):
        """
        Statistics over all Admin object ( from ADMINDIR directory) --> dict
        """
        stat = {}

        for k,v in self.queueMax.items():
            stat[k]={ 'max': v, 'tot':0, 'run':0, 'que':0 ,'oth':0 }

        for admin in self.admins:
            queue = admin.getQueue()
            status = admin.getStatus()
            if stat.has_key( queue ):
                stat[queue]['tot'] += 1

                #  summitted , pending, running, finished , error
                if status == 'running':
                    stat[queue]['run'] += 1
                elif status == 'pending' or status == 'summitted':
                    stat[queue]['que'] += 1
                else:
                    stat[queue]['oth'] += 1
        return stat

    def queueStatDisplay( self , total = False ):
        """
        Display statistics over all administrative files in the
        administrative directory.
        """
        stat = self.queueStat()

        ## header
        st = "%-8s  %4s  %4s  %4s  %4s  %4s" %('Queue', 'Max', 'Tot', 'Que', 'Run', 'Oth') + '\n'
        st += "%8s  %4s  %4s  %4s  %4s  %4s" % ('-'*8, '-'*4, '-'*4, '-'*4, '-'*4, '-'*4)

        for key, value in stat.items():
            print >>sys.stdout, "%-8s  %4s  %4d  %4d  %4d  %4d" % ( key, value['max'], value['tot'], value['que'], value['run'] , value['oth'] )

        if total:
            tque, trun, toth = 0, 0, 0
            for queue in stat.values():
                tque += queue['que']
                trun += queue['run']
                toth += queue['oth']
            print >>sys.stdout, "%8s  %4s  %4s  %4s  %4s  %4s" % (' '*8, ' '*4, ' '*4, '-'*4, '-'*4, '-'*4 )
            print >>sys.stdout, "%8s  %4s  %4s  %4s  %4s  %4s" % (' '*8, ' '*4, ' '*4, tque, trun, toth )


    ### Display


    def display( self , strfn='str_bioweb' ):
        """
        Display informations of services which are still running.

        strfn is a fonction called to special display.

        """

        if strfn in dir( self ):
            f='self.'+ strfn
            fonc= eval( f )
        else:
            fonc = strfn

        self.admins.sort( key = self._key )

        if self.admins and strfn == 'str_colum':
                print >>sys.stdout, self._strColumnHeader()

        for admin in self.admins:
            if self.hasQueueKey() and admin.getQueue() != self.queueKey:
                continue
            st = ''
            st =  fonc ( admin )
            if st:
                print >>sys.stdout, st


    def str_admin ( self, admin ):
        """
        Display Admin object
        """
        return admin.__str__()


    def str_bioweb( self, admin ):
        """
        Display like Rosalind jobw
        """

        # line 1
        st1 = []
        if self.diplay['number'] and admin.getNumber():
            st1.append( str(admin.getNumber()) )
        if self.diplay['batch'] and admin.getBatch():
            st1.append( admin.getBatch() )
        if self.diplay['queue'] and admin.getQueue():
            st1.append( admin.getQueue() )
        if self.diplay['status'] and admin.getStatus():
            st1.append( admin.getStatus()[0] )
        if st1:
            st1 = ' -- '.join(st1) + '\n'
        else:
            st1 = ''

        # line 2
        jobName =  admin.getJobName()
        jobKey = admin.getJobID().split('/')[-1]

        st2 = []
        if self.diplay['jobname'] and jobName:
            st2.append( jobName )
        if self.diplay['jobkey'] and jobKey:
            st2.append( jobKey )
        if self.diplay['email'] and admin.getEmail():
            st2.append( admin.getEmail() )
        if self.diplay['remote'] and admin.getRemote():
            st2.append( admin.getRemote() )
        if self.diplay['date'] and admin.getDate():
            st2.append( time.strftime("%x %X",admin.getDate()) )
        if st2:
            st2 = ' -- '.join(st2) + '\n'
        else:
            st2 = ''

        # line 3
        cmd = ''
        if self.diplay['command']:
            cmd_path = os.path.join( self.config.results_path(), jobName, jobKey, '.command')
            try:
                fh = open( cmd_path )
                cmd = fh.readline()
                fh.close()
            except IOError, err:
                print >>sys.stderr,  "%s" % ( err )

        # line 4
        if self.diplay['session']:
            st3 = admin.getSession() + '\n'
        else:
            st3 = ''

        # line sep
        if st1 or st2 or st3 or cmd:
            sep = '-'*80
        else:
            sep = ''
        return st3 + st1 + st2 + cmd + sep


    def _strColumnHeader( self ):
        """
        Display header for column's display
        """
        st = "%-20s  %-20s  %-25s  %10s   %-8s" %('Number', 'JobKey', 'User Email', 'Time Use', 'Queue') + '\n'
        st += "%20s  %20s  %25s  %10s   %8s" % ('-'*20, '-'*20, '-'*25, '-'*10, '-'*8)
        return st

    def str_column( self, admin ):
        """
        Display as column
        """
        number = str( admin.getNumber() )
        email = admin.getEmail()
        queue = admin.getQueue()
        date = admin.getDate()
        jobkey = admin.getJobID().split('/')[-1]

        dateS = time.mktime( date )           # tuple -> float
        timeS = time.time()                   # float
        useS = timeS - dateS                  # float

        mn, rs = divmod( int(useS), 60)
        h, rmn = divmod( mn, 60)
        reprTime = "%.2d:%2.2d:%2.2d" % (h, rmn , rs)

        return "%-20s %-20s  %-25s  %10s   %-8s" %( number, jobkey, email, reprTime, queue)

    def _key ( self, admin ):
        """
        for the sort( cmp, key ) methode of list object
        """

        if self.sortKey == 'Date':
            return time.mktime( admin.getDate() )

        f = 'admin.get'+ self.sortKey
        fct = eval( f )
        return fct()

    def setSortKey( self, sortKey ):
        """
        Set the sortKey attribute with the given sortkey. Specifies sort methode
        to order informations for printing.
        """

        if self.keysAssociation.has_key( sortKey ):
            self.sortKey = self.keysAssociation[ sortKey ]
        else:
            self.sortkey = sortKey.capitalize()

    def setQueueKey( self, queuekey ):
        """
        Set the queueKey attribute with the given queuekey.
        """
        self.queueKey = queuekey

    def hasQueueKey ( self ):
        """
        Test if a QueueKey is set on or not.  --> bool
        """
        return self.queueKey is not None

    def turnOff_diplay( self ):
        """
        Nothing of the 'Administrative File' will be print
        """
        for k in self.diplay.iterkeys():
            self.diplay[k] = False

    def setDisplay( self, opt, bool ):
        """
        Set the given display option with the given bool.
        """
        self.diplay[ opt ] = bool
