#! /usr/bin/env python

import os, sys, getopt

# ====== Mobyle modules:

# append Mobyle Home to the search modules path
try:
    _MOBYLEHOME = os.environ[ 'MOBYLEHOME' ]
except KeyError:
    _MOBYLEHOME = '/Users/maufrais/Developpements/Mobyle'
if _MOBYLEHOME not in sys.path:
    sys.path.append( _MOBYLEHOME )

# append Mobyle Src
if (os.path.join(_MOBYLEHOME,'Src')) not in sys.path:
    sys.path.append(os.path.join(_MOBYLEHOME,'Src'))

# ===== end

import Ccleaner


def usage():
    print """
    usage: cleaner [options]


    Clean Result or Anonymous sessions of Mobyle (Result by default)

    options:
        -h       ... Print this message and exit.
        -d <val> ... Delete files older than <val> days ( positive value ).
        -s <val> ... Delete files bigger than <val> Go ( positive value ).
        -z <val> ... Delete archives older than <val> days ( positive value ).
        -f       ... Force: ignore nonexistent files, never prompt
        -v       ... Turn off verbose mode
        -J       ... Clean Results
        -S       ... Clean anonymous sessions
    """


# ===== command line parser
try:
    opts, args = getopt.gnu_getopt( sys.argv[1:], "hJSfvd:s:z:",
                                    ["help","force", "result", "session", "verbose", "day=",  "size=", "zip="] )
except getopt.GetoptError:
    usage()
    sys.exit( 0 )


day, size, zip = 0, 0, 0
force = False
verbose = True
result = False
session = False

if not opts:
    usage()
    sys.exit( 0 )

for o, v in opts: #( opt, value )
    if o in ( "-h","--help" ):
        usage()
        sys.exit( 0 )

    if o in ( "-d", "--day" ):
        day = float( v )
    elif o in ( "-s", "--size" ):
        size = float( v )
    elif o in ( "-z" , "--zip"):
        zip = float( v )
    elif o in ( "-f" , "--force"):
        force = True
    elif o in ( "-v" , "--verbose"):
        verbose = True
    elif o in ( "-S" , "--session"):
        session = True
    elif o in ( "-J", "--result"):
        result = True

if day < 0. or zip < 0. or size < 0.:
    usage()
    sys.exit( 0 )


# ===== cleaner


cleaner = Ccleaner.Cleaner( force = force, verbose=verbose, session = session )

if not session:

    if day:
        cleaner.jobKeyCleaner( jobTime=day )
    elif size or zip:
        cleaner.jobFileCleaner( fileSize=size, zipTime=zip  )
    else:
        usage()
        sys.exit( 0 )

elif not result:
    if day:
        cleaner.anonymousSessionCleaner( jobTime=day )
    else:
        usage()
        sys.exit( 0 )
else:
    if day:
        cleaner.jobKeyCleaner( jobTime=day )
        cleaner.anonymousSessionCleaner( jobTime=day )
    elif size or zip:
        cleaner.jobFileCleaner( fileSize=size, zipTime=zip  )
    else:
        usage()
        sys.exit( 0 )