<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" indent="yes"/>
    
    
    <xsl:template match="/">
        
        <html>
            <head>
            	<title> <xsl:value-of select="/jobState/name"/> results </title>
                
                <link>
                    <xsl:attribute name="href"><xsl:value-of select="/jobState/host" />/Mobyle/index.css</xsl:attribute>
                    <xsl:attribute name="title">indexstyle</xsl:attribute>
                    <xsl:attribute name="rel">stylesheet</xsl:attribute>
                    </link>
                </head>
            
          	<div class="header">
        <h1>
            <xsl:value-of select="/jobState/name"/>
        </h1>
        <p> this job has been submitted the :
            <xsl:value-of select="/jobState/date"/> <br/> 
            on <xsl:value-of select="/jobState/host"/> Mobyle server.
            <br/> It's Identifier is : <xsl:value-of select="/jobState/id"/>
        </p>
        </div>
            
            
        <hr/>
        
            
        <div class="data">    
        <h2> Datas formatting </h2>
        
        <xsl:for-each select='/jobState/SequenceFile'>
            <xsl:call-template name='sequencefile'/>
        </xsl:for-each>
        </div>
            
        <hr/>
 		<div class="param">
        <h2> Job Parameters </h2>
        <xsl:for-each select='/jobState/args'>
            <xsl:call-template name='args'/>
        </xsl:for-each>
        </div>
            
        <hr/>
        <div class="command">
        <h2>Command</h2> the unix command line is :
        <br/>
        <xsl:value-of select="/jobState/command"/>
        </div>
            
        <hr/>
		
        <div class="result">
        <h2> Job results </h2>
        your job is
        <xsl:value-of select="/jobState/status/value"/> .
        
        <xsl:if test="/jobState/status/message">
            <xsl:value-of select="/jobState/status/message" />
        </xsl:if>
        
        <xsl:choose>
            <xsl:when test="/jobState/results">
                <br/> the results file are:
                <xsl:for-each select='/jobState/results'>
                    <xsl:call-template name='results'/>
                </xsl:for-each> </xsl:when>
            <xsl:otherwise>
                <br/>No results available at this time</xsl:otherwise>
        </xsl:choose>
        </div>
            
      
        </html>
        </xsl:template>
    
    <xsl:template name='sequencefile'>
        <p> your sequence file
            <xsl:value-of select="inFileName"/>, corresponding to the parameter
            <xsl:value-of select="param"/>, has been detetcted as
            <xsl:value-of select="in"/> format by the sequence checker software
            <xsl:value-of select="program"/>
            <xsl:if test='out'> and transform in
                <xsl:value-of select="out"/> format with name
                <xsl:value-of select="outFileName"/>. 
            </xsl:if> 
        </p>
    </xsl:template>
    
    <xsl:template name='args'>
        <ul>
            <xsl:for-each select="arg">
                <li>
                    <xsl:value-of select="@name"/> =
                    <xsl:value-of select='.'/> </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name='results'>
        <ul>
            <xsl:for-each select="file">
                <li>
                    <a>
                        <xsl:attribute name="href">
                            <xsl:value-of select="/jobState/id"/>/<xsl:value-of select="."/> </xsl:attribute>
                        <xsl:value-of select="."/>
                    </a>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
</xsl:stylesheet>
