<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" encoding="ISO-8859-1"
    doctype-public="program"
    doctype-system="../mobyle.dtd" />
  
  <!-- process only program element -->
  <xsl:template match="/">
    <xsl:apply-templates select="mobyle/program" />
  </xsl:template>
  
  <!-- general template copy everything you find in the input, unless otherwise specified -->
  <xsl:template match="*">
    <!-- copy element -->
    <xsl:copy>
      <!-- copy its attributes -->
      <xsl:copy-of select="@*"/>
      <!-- process its sub-elements -->
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <!-- delete datainput element -->
  <xsl:template match="datainput" />

  <xsl:template match="parameter">
    <xsl:copy>
      <!-- delete attributes that are not used anymore, copy the others -->
      <xsl:copy-of select="@*[name(.)!='class' and name(.)!='superclass' and name(.)!='bioMoby' and name(.)!='multiple']"/>
      <!-- create ismaininput attribute -->
      <xsl:if test="//head/datainput/param[text()=current()/name/text()]">
        <xsl:attribute name="ismaininput">1</xsl:attribute>
      </xsl:if>
      <!-- reorder sub-elements -->
      <xsl:apply-templates select="name" />
      <!-- reorder sub-elements and delete attributes intermediate level -->
      <xsl:apply-templates select="attributes/prompt" />
      <!-- create the type element -->
      <xsl:call-template name="type" />
      <xsl:apply-templates select="attributes/precond" />
      <xsl:apply-templates select="attributes/vdef" />
      <xsl:if test='not(attributes/flist)'>
      <!-- we process vlist only if flist is not specified (in which case vlist and flist are merged into flist -->
        <xsl:apply-templates select="attributes/vlist" />
      </xsl:if>
      <xsl:apply-templates select="attributes/flist" />
      <xsl:apply-templates select="attributes/separator" />
      <xsl:apply-templates select="attributes/format" />
      <xsl:apply-templates select="attributes/ctrl" />
      <xsl:apply-templates select="attributes/scale" />
      <xsl:apply-templates select="attributes/argpos" />
      <xsl:apply-templates select="attributes/comment" />
      <xsl:apply-templates select="attributes/paramfile" />
      <xsl:apply-templates select="attributes/filenames" />
      <xsl:apply-templates select="interface" />
      <xsl:apply-templates select="attributes/width" />
      <xsl:apply-templates select="attributes/height" />
      <xsl:apply-templates select="attributes/example" />
    </xsl:copy>  
  </xsl:template>

  <xsl:template match="paragraph">
    <xsl:copy>
      <!-- reorder sub-elements -->
      <xsl:apply-templates select="name" />
      <xsl:apply-templates select="prompt" />
      <xsl:apply-templates select="precond" />
      <xsl:apply-templates select="format" />
      <xsl:apply-templates select="argpos" />
      <xsl:apply-templates select="comment" />
      <xsl:apply-templates select="parameters" /> 
      <xsl:apply-templates select="layout" />
     </xsl:copy>  
  </xsl:template>
  
  <xsl:template name="type">
    <type>
      <datatype>
        <class><xsl:value-of select="@class" /></class>
        <xsl:if test="@superclass">
          <superclass><xsl:value-of select="@superclass" /></superclass>      
        </xsl:if>
      </datatype>
      <xsl:if test="attributes/seqfmt">
        <acceptedDataFormats>
          <xsl:for-each select="attributes/seqfmt/value">
             <dataFormat><xsl:value-of select="." /></dataFormat>
            </xsl:for-each>
        </acceptedDataFormats>
      </xsl:if>
    </type>
  </xsl:template>

  <xsl:template match="vlist">
    <xsl:copy>
      <xsl:for-each select='value'>
        <velem>
          <xsl:apply-templates select="." />          
          <xsl:apply-templates select="following-sibling::label[1]" />          
        </velem>
      </xsl:for-each>
    </xsl:copy>    
  </xsl:template>

  <xsl:template match="flist">
    <xsl:copy>
      <xsl:for-each select='value'>
        <felem>
          <xsl:apply-templates select="." />
          <xsl:if test="not(../../vlist/value[text()=current()/text()]/following-sibling::label[1])">
            <label></label>
          </xsl:if>
          <xsl:apply-templates select="../../vlist/value[text()=current()/text()]/following-sibling::label[1]" />          
          <xsl:apply-templates select="./following-sibling::code[1]" />          
        </felem>
      </xsl:for-each>
    </xsl:copy>    
  </xsl:template>


</xsl:stylesheet>
