<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" encoding="ISO-8859-1" doctype-system="../mobyle.dtd" indent="yes" />



  <!-- general template copy everything you find in the input, unless otherwise specified -->
  <xsl:template match="*">
    <!-- copy element -->
    <xsl:copy>
      <!-- copy its attributes -->
      <xsl:copy-of select="@*" />
      <!-- process its sub-elements -->
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <!-- general template -->

  <xsl:template match="/">

    <program>
      <head>
        <xsl:apply-templates select='/pise/head' />
      </head>
        <xsl:apply-templates select='/pise/parameters' />
    </program>

  </xsl:template>


  <!-- template for the head -->

  <xsl:template match='/pise/head'>

    <name>
      <xsl:value-of select='/pise/command' />
    </name>

    <xsl:apply-templates select='version' />

    <doc>
      <xsl:apply-templates select='title' />
      <xsl:if test='description'>
        <description>
          <text lang="en">
            <xsl:value-of select='description' />
          </text>
        </description>
      </xsl:if>
      <xsl:apply-templates select='authors' />
      <xsl:apply-templates select='reference' />
      <xsl:apply-templates select='doclink' />
    </doc>

    <xsl:apply-templates select='category' />
    <xsl:apply-templates select='/pise/command' />  
    
  </xsl:template>

  

  <!-- template for parameter -->

  <xsl:template match="parameter">

    <parameter>
      <xsl:if test="@ismandatory ">
        <xsl:attribute name="ismandatory">
          <xsl:value-of select="@ismandatory" />
        </xsl:attribute>
      </xsl:if>

      <xsl:if test="@iscommand ">
        <xsl:attribute name="iscommand">
          <xsl:value-of select="@iscommand" />
        </xsl:attribute>
      </xsl:if>

      <xsl:if test="@ishidden ">
        <xsl:attribute name="ishidden">
          <xsl:value-of select="@ishidden" />
        </xsl:attribute>
      </xsl:if>

      <xsl:if test="@isstandout ">
        <xsl:attribute name="isstdout">
          <xsl:value-of select="@isstandout" />
        </xsl:attribute>
      </xsl:if>

      <xsl:if test="@issimple ">
        <xsl:attribute name="issimple">
          <xsl:value-of select="@issimple" />
        </xsl:attribute>
      </xsl:if>

      <xsl:if test="@isclean ">
        <xsl:attribute name="isclean">
          <xsl:value-of select="@isclean" />
        </xsl:attribute>
      </xsl:if>

      <xsl:if test="@type = 'Results' ">
        <xsl:attribute name="isout">1</xsl:attribute>
      </xsl:if>

      <xsl:if test="@type = 'OutFile' ">
        <xsl:attribute name="isout">1</xsl:attribute>
      </xsl:if>

      <xsl:copy-of select='name' />

      <xsl:for-each select='attributes/prompt'>
        <xsl:call-template name='prompt' />
      </xsl:for-each>

      <type>

        <xsl:if test="@type">

          <xsl:choose>
            <xsl:when test="@type = 'Results' ">
              <datatype>
                <class>Text</class>
              </datatype>
            </xsl:when>
            <xsl:when test="@type = 'Excl' ">
              <datatype>
                <class>Choice</class>
              </datatype>
            </xsl:when>
            <xsl:when test="@type = 'List' ">
              <datatype>
                <class>MultipleChoice</class>
              </datatype>
            </xsl:when>
            <xsl:when test="@type = 'OutFile' ">
              <datatype>
                <class>Text</class>
              </datatype>
            </xsl:when>
            <xsl:when test="@type = 'Switch' ">
              <datatype>
                <class>Boolean</class>
              </datatype>
            </xsl:when>
            <xsl:when test="@type = 'InFile' ">
              <datatype>
                <class>Text</class>
              </datatype>
            </xsl:when>
            <xsl:when test="@type = 'Sequence' ">
              <xsl:choose>
                <xsl:when test="./attributes/seqtype[. = 'dna' ] ">
                  <datatype>
                    <biotype>DNA</biotype>
                    <class>Sequence</class>
                  </datatype>
                </xsl:when>
                <xsl:when test="./attributes/seqtype[. = 'rna' ] ">
                  <datatype>
                    <biotype>RNA</biotype>
                    <class>Sequence</class>
                  </datatype>
                </xsl:when>
                <xsl:when test="./attributes/seqtype[. = 'protein' ] ">
                  <datatype>
                    <biotype>Protein</biotype>
                    <class>Sequence</class>
                  </datatype>
                </xsl:when>
                <xsl:otherwise>
                  <datatype>
                    <class>Sequence</class>
                  </datatype>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <datatype>
                <class>
                  <xsl:value-of select="@type" />
                </class>
              </datatype>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>

        <xsl:for-each select='attributes/seqfmt'>
          <acceptedDataFormats>
            <xsl:for-each select='value'>
              <dataFormat>

                <xsl:choose>
                  <xsl:when test=". = 1 ">IG</xsl:when>
                  <xsl:when test=". = 2 ">GENBANK</xsl:when>
                  <xsl:when test=". = 3 ">NBRF</xsl:when>
                  <xsl:when test=". = 4 ">EMBL</xsl:when>
                  <xsl:when test=". = 5 ">GCG</xsl:when>
                  <xsl:when test=". = 8 ">FASTA</xsl:when>
                  <xsl:when test=". = 11 ">PHYLIPS</xsl:when>
                  <xsl:when test=". = 12 ">PHYLIP</xsl:when>
                  <xsl:when test=". = 13 ">RAW</xsl:when>
                  <xsl:when test=". = 14 ">PIR</xsl:when>
                  <xsl:when test=". = 15 ">MSF</xsl:when>
                  <xsl:when test=". = 17 ">NEXUS</xsl:when>
                  <xsl:when test=". = 100">CLUSTAL</xsl:when>
                  <xsl:when test=". = 101">STOCKHOLM</xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="." />
                    UNKNOWN
                  </xsl:otherwise>
                </xsl:choose>

              </dataFormat>
            </xsl:for-each>
          </acceptedDataFormats>
        </xsl:for-each>

      </type>

      <xsl:for-each select='attributes/precond'>
        <xsl:call-template name='precond' />
      </xsl:for-each>

      <xsl:if test='attributes/vdef'>
        <vdef>
          <xsl:for-each select='attributes/vdef/value'>
            <value>
              <xsl:value-of select='.' />
            </value>
          </xsl:for-each>

          <xsl:for-each select='attributes/vdef/language'>
            <xsl:call-template name="code" />
          </xsl:for-each>
        </vdef>
      </xsl:if>

      <xsl:if test='not(attributes/flist)'>
        <!-- we process vlist only if flist is not specified (in which case vlist and flist are merged into flist -->
        <xsl:apply-templates select="attributes/vlist" />
      </xsl:if>
      <xsl:apply-templates select="attributes/flist" />

      <xsl:for-each select='attributes/separator'>
        <xsl:copy-of select='.' />
      </xsl:for-each>

      <xsl:for-each select='attributes/format'>
        <xsl:call-template name='format' />
      </xsl:for-each>

      <xsl:for-each select='attributes/ctrls'>
        <xsl:for-each select='ctrl'>
          <ctrl>
            <message>
              <text lang="en">
                <xsl:value-of select='message' />
              </text>
            </message>
            <xsl:for-each select='language'>
              <xsl:call-template name='code' />
            </xsl:for-each>
          </ctrl>
        </xsl:for-each>
      </xsl:for-each>

      <xsl:if test='attributes/scalemin or attributes/scalemax'>
        <scale>
          <xsl:for-each select='attributes/scalemin'>
            <min>
              <xsl:if test='value'>
                <xsl:copy-of select='value' />
              </xsl:if>
              <xsl:for-each select='language'>
                <xsl:call-template name="code" />
              </xsl:for-each>
            </min>
          </xsl:for-each>
          <xsl:for-each select='attributes/scalemax'>
            <max>
              <xsl:if test='value'>
                <xsl:copy-of select='value' />
              </xsl:if>
              <xsl:for-each select='language'>
                <xsl:call-template name="code" />
              </xsl:for-each>
            </max>
          </xsl:for-each>
          <xsl:for-each select='attributes/scaleinc'>
            <inc>
              <xsl:if test='value'>
                <xsl:copy-of select='value' />
              </xsl:if>
              <xsl:for-each select='language'>
                <xsl:call-template name="code" />
              </xsl:for-each>
            </inc>
          </xsl:for-each>
        </scale>
      </xsl:if>

      <xsl:for-each select='attributes/group'>
        <xsl:call-template name="group" />
      </xsl:for-each>

      <xsl:for-each select='attributes/comment'>
        <xsl:call-template name='comment' />
      </xsl:for-each>

      <xsl:for-each select='attributes/paramfile'>
        <paramfile>
          <xsl:value-of select='.' />
        </paramfile>
      </xsl:for-each>

      <xsl:for-each select='attributes/filenames'>
        <filenames>
          <code proglang="perl">
            <xsl:value-of select='.' />
          </code>
        </filenames>
      </xsl:for-each>

      <xsl:for-each select='attributes/size'>
        <width>
          <xsl:value-of select="." />
        </width>
      </xsl:for-each>

      <xsl:for-each select='attributes/info'>
        <info>
          <xsl:value-of select='.' />
        </info>
      </xsl:for-each>

    </parameter>

  </xsl:template>

  <!-- paragraphs template this template used the xpath rescursive operator -->

  <xsl:template match="//parameter[@type = 'Paragraph']">
    <paragraph>

      <name>
        <xsl:value-of select='./paragraph/name' />
      </name>

      <xsl:for-each select='./paragraph/prompt'>
        <xsl:call-template name='prompt' />
      </xsl:for-each>

      <xsl:for-each select='./paragraph/precond'>
        <xsl:call-template name='precond' />
      </xsl:for-each>

      <xsl:for-each select='./paragraph/format'>
        <xsl:call-template name='format' />
      </xsl:for-each>

      <xsl:for-each select='./paragraph/group'>
        <xsl:call-template name='group' />
      </xsl:for-each>


      <xsl:for-each select='./paragraph/comment'>
        <xsl:call-template name='comment' />
      </xsl:for-each>

      <xsl:for-each select='./paragraph'>

          <xsl:apply-templates select='parameters' />
      </xsl:for-each>
    </paragraph>
  </xsl:template>

  <!-- template used by paragraph and parameter -->

  <xsl:template name='prompt'>
    <prompt lang="en">
      <xsl:value-of select='.' />
    </prompt>
  </xsl:template>

  <xsl:template name='precond'>
    <precond>
      <xsl:for-each select='language'>
        <xsl:call-template name='code' />
      </xsl:for-each>
    </precond>
  </xsl:template>

  <xsl:template name='group'>
    <argpos>
      <xsl:value-of select='.' />
    </argpos>
  </xsl:template>

  <xsl:template name='format'>
    <format>
      <xsl:for-each select='language'>
        <xsl:call-template name="code" />
      </xsl:for-each>
    </format>
  </xsl:template>

  <xsl:template name='comment'>
    <comment>
      <xsl:for-each select='value'>
        <text lang="en">
          <xsl:value-of select='.' />
        </text>
      </xsl:for-each>
    </comment>
  </xsl:template>

  <xsl:template name='code'>
    <code>
      <xsl:attribute name="proglang">
        <xsl:value-of select='.' />
      </xsl:attribute>
      <xsl:value-of select="./following-sibling::code" />
    </code>
  </xsl:template>


  <xsl:template match="vlist">
    <xsl:copy>
      <xsl:for-each select='value'>
        <velem>
          <xsl:apply-templates select="." />
          <xsl:apply-templates select="following-sibling::label[1]" />
        </velem>
      </xsl:for-each>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="flist">
    <xsl:copy>
      <xsl:for-each select='value'>
        <felem>
          <xsl:apply-templates select="." />
          <xsl:if test="not(../../vlist/value[text()=current()/text()]/following-sibling::label[1])">
            <label></label>
          </xsl:if>
          <xsl:apply-templates select="../../vlist/value[text()=current()/text()]/following-sibling::label[1]" />
          <code>
            <xsl:attribute name="proglang">perl</xsl:attribute>
            <xsl:value-of select="./following-sibling::code[1]" />
          </code>
        </felem>
      </xsl:for-each>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
