import os ,  os.path
import sys
import cPickle as pickle
import fcntl

try:
    _MOBYLEHOME = os.environ['MOBYLEHOME']
except KeyError :
    os.environ['MOBYLEHOME']= "/local/bioweb/Mobyle"
    _MOBYLEHOME = os.environ['MOBYLEHOME']    


if (os.path.join(_MOBYLEHOME,'Src')) not in sys.path:    
    sys.path.append(os.path.join(_MOBYLEHOME,'Src'))
    

from Mobyle import SequenceConverter , AlignmentConverter
from Mobyle.Session import *
from Mobyle.MobyleError import *


READ = fcntl.LOCK_SH
WRITE = fcntl.LOCK_EX
transactionFile = ''
transactionLockType = None

   
   
     
def getTransaction( Type ): 
      global READ
      global WRITE
      global transactionFile
      global transactionLockType
             
      Dir= os.getcwd()
      fileName = os.path.normpath( os.path.join( Dir , '.session.dump'  ) )
      try:
          if Type == READ :
              transactionFile = open( fileName , 'r' )
          elif Type == WRITE :
              transactionFile = open( fileName , 'r+' )
          else:
              raise MobyleError
      except IOError , err:
          msg = "can't open session %s : %s" %( Dir , err )
          print >> sys.stderr , msg
          raise MobyleError
      
      try:
         fcntl.lockf( transactionFile , Type | fcntl.LOCK_NB )
         IGotALock  = True
      except IOError , err :

         IGotALock = False
         
         for attempt in range(3):
            try:
               fcntl.lockf( transactionFile , Type | fcntl.LOCK_NB )
               IGotALock  = True
               break
            except IOError:
               time.sleep( 0.2 )

         if not IGotALock :
            transactionFile.close()
            transactionFile = None
            transactionLockType = None
            print >> sys.stderr , "session/%s : %s" %( err ) 
            raise IOError , err

      transactionLockType = Type
      try:
          transaction = pickle.load( transactionFile )
      except Exception , err:
          import shutil
          shutil.copy2( transactionFile.name , transactionFile.name + ".copy")
          
          import  traceback, StringIO
          traceback.print_exc()
          print >> sys.stderr.getvalue() 
          
      return transaction

    

def commit( transaction ):
      """
      """
      global READ
      global WRITE
      global transactionFile
      global transactionLockType
      
      try:
          if transactionLockType == WRITE :
             try:
                tmpFile = open( transactionFile.name + ".tmp"  , 'w' )
                pickle.dump( transaction , tmpFile  )
             except IOError , err :
                 print >> sys.stderr , "can't commit this transaction: " + str( err )
                 raise MobyleError , msg
             os.rename( tmpFile.name , transactionFile.name )
          try:
             fcntl.lockf( transactionFile , fcntl.LOCK_UN  )
             transactionFile.close()
             transactionFile = None
             transactionLockType = None
          except IOError , err :
             print >> sys.stderr , "an error occured durring commiting transaction : " + str( err )
             pass
             # a gerer
      except Exeption ,err:
          transactionFile = None
          transactionLockType = None
          import traceback, StringIO
          sys.stderr = StringIO.StringIO()
          traceback.print_exc()
          print >> sys.stderr , sys.stderr.getvalue() 
          
      os.chdir('..')     
          
def close( transaction ):
      """
      """
      global READ
      global WRITE
      global transactionFile
      global transactionLockType
            
      try:
         fcntl.lockf( transactionFile , fcntl.LOCK_UN  )
         transactionFile.close()
         transactionFile = None
         transactionLockType = None
      except IOError , err :
         print >> sys.stderr , "an error occured durring closing transaction : " + str( err ) 
         pass
         # a gerer   
      os.chdir('..')

  
allSessions = sys.argv[1:]

for sessionDir in allSessions:
     os.chdir( sessionDir )
     print >> sys.stderr ,  "------------------- mise a jour de la session %s --------------------------" % os.getcwd()
     print >> sys.stderr , "ouverture de la transaction"
     try:
         transaction = getTransaction( WRITE )
     except Exception ,err:
         print  >> sys.stderr , "echec de l'ouverture de la transaction : " , err 
         continue
     
     try:
         if transaction.jobs :
             for jobID in transaction.jobs.keys():
                 if not transaction.jobs[ jobID ].has_key( 'userName' ):
                     try:
                         print "mise a jour du userName"
                         transaction.jobs[ jobID ][ 'userName' ] = jobID
                     except Exception , err:
                         print >> sys.stderr , "erreur lors de l'update du userName"
                         print >> sys.stderr , err
                 else:
                     print "le champs userName est deja a jour = " , transaction.jobs[ jobID ]['userName']
                     
             commit( transaction )
         else:
               print >> sys.stderr ,"pas de jobs dans la transaction"
               close( transaction )

     
     except Exception , err:
         import traceback, StringIO
         tmp_stderr = sys.stderr
         sys.stderr = StringIO.StringIO()
         traceback.print_exc()
         print >> sys.stdout , sys.stderr.getvalue() 
         sys.stderr = tmp_stderr
         print >> sys.stderr , "la mise a jour de la session %s a echoue"%sessionDir

         for jobID in transaction.jobs.keys():
             try:
                 print >> sys.stderr , jobID  ," = " , transaction.jobs[ jobID ][ 'userName']
             except KeyError:
                 print >> sys.stderr , jobID  ," = " , 'pas de champs userName'
                 
                 
             print "                          -----------------------------"            
                 
         print >> sys.stderr ,"etat du repertoire : " , os.listdir( os.getcwd() )

         close( transaction )
         
         
         
                                                  
