import sys
import os.path

from Mobyle.MobyleError import *

import logging 
p_log = logging.getLogger('mobyle.policy')



def queue( queueName ):
    """
    @return: the name of the queue to be used to execute the job
    @rtype: string
    """
    return queueName



def emailCheck( **args ):
    """
    check if the email according to the local rules.
    @return:
     - Mobyle.Net.EmailAddress.VALID    if the email is valid
     - Mobyle.Net.EmailAddress.INVALID  if the email is rejected
     - Mobyle.Net.EmailAddress.CONTINUE to continue futher the email validation process
    """
    import Mobyle.Net

    user , domainName  = args['email'].split('@')

    if domainName == 'pasteur.fr':
        try:
            local = isLocal( user )
        except MobyleError , err:
            p_log.critical( "an error is occured during checking local login : "+ str( err ))
            # I don't stop Mobyle for that. The user continue as an external user
            return Mobyle.Net.EmailAddress.CONTINUE
        
        if local:
            return Mobyle.Net.EmailAddress.VALID
        else:
            return Mobyle.Net.EmailAddress.INVALID
    else:
        return Mobyle.Net.EmailAddress.CONTINUE
        

def isLocal( userName ):
    """
    @return: True if the userName is a pasteur login, False otherwise.
    @rtype: False
    """
    try:
        loginFileName = '/home/bneron/Mobyle/Stable/Mobyle/Local/logins'
        fh = open( loginFileName , "r" )
    except IOError , err:
        raise MobyleError , err
    
    allLogins= fh.readlines()
    if allLogins :
        userName = userName +'\n'
        return userName in allLogins
 
    else:
        raise MobyleError , "the pasteur login list is empty ! "
