#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
"""
Mobyle.Index

This module manages the list of available programs to:
 - search them (using search fields)
 - classify them (building the categories tree)
 - cache this information (on disk as a JSON file)
"""
import os
import string
import Mobyle.ConfigManager
from Mobyle.Registry import *
from Mobyle.MobyleError import MobyleError
from Ft.Xml.Domlette import NoExtDtdReader
from Ft.Xml.Domlette import Print
from Ft.Xml.XPath import Compile, Evaluate
from Ft.Lib import UriException
import pickle
import re

import logging
from Mobyle import MobyleLogger
from Mobyle import IndexBase
MobyleLogger.MLogger()
r_log = logging.getLogger('mobyle.index' )

_cfg = Mobyle.ConfigManager.Config()

queries = {
           u'description': Compile(u'/program/head/doc/description/text/text()'),
          }

class DescriptionsIndex(IndexBase.Index):
    
    indexPath = os.path.join(IndexBase.Index.indexFolder, 'descriptions.dat')

    def fillRegistry(self):
        for url, description in self.index.items():
            if registry.programsByUrl.has_key(url):
                registry.programsByUrl[url].description = description
    
    @classmethod
    def getIndexEntry(cls, doc, program):
        """
        Return an description index entry value
        @return: the index entry: value
        @rtype: object
        """
        return IndexBase._XPathQuery(doc, queries['description'])