#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.JobFacade import JobFacade

class JobKill(mb_cgi.JSONCGI):
  """
  JobKill is used to kill jobs from a remote mobyle portal.
  @author: Herve Menager
  @author: Bertrand Neron
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """
    
  def process(self):
    j = JobFacade.getFromJobId(self.request.getfirst('jobId',None))
    self.result = j.killJob()
    
  def render(self):
    render = self.request.getfirst("render","json")
    self.jsonMap = self.result
    super(JobKill,self).render()
                        
if __name__ == "__main__":
    js = JobKill()
    js.process()
    js.render()