#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import Mobyle.MobyleJob 
from Mobyle.MobyleError import *
from Mobyle.Registry import registry

class JobView(mb_cgi.XSLCGI):
  """
  This class is a CGI interface to the MobyleJob class.
  @author: Herve Menager
  @author: Bertrand Neron
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """
      
  def process(self):
    # program exists on the Server
    try:
      self.job = Mobyle.MobyleJob.MobyleJob(ID=self.request.getfirst('jobid'))
      self.progFileName = registry.programsByUrl[self.job.jobState.getName()].path
    except MobyleError, me:
      self.error_msg = "This job does not exist."
      self.progFileName = ""
      return
    self.xmlUrl = self.job.getJobid()+'/index.xml'

  def render(self):
    self.xslParams = {u'isInPortal': u'true',u'local': u'no',\
                      u'serviceXmlUri': self.progFileName,\
                      u'previewDataLimit':self.cfg.previewDataLimit(),}
    self.xsltUri = self.cfg.portal_path()+'/xsl/job.xsl'
    super(JobView,self).render()
      
if __name__ == "__main__":
  js = JobView()
  js.process()
  js.render()
