#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import sys,os
import logging
import cgi ,time, Cookie
import StringIO
import md5
import glob
from simpletal import simpleTAL, simpleTALES
from simpletal.simpleTALUtils import FastStringOutput

MOBYLEHOME = None
if os.environ.has_key('MOBYLEHOME'):
    MOBYLEHOME = os.environ['MOBYLEHOME']

if (os.path.join(MOBYLEHOME,'Src')) not in sys.path:
  sys.path.append(os.path.join(MOBYLEHOME,'Src'))


try:
    import Mobyle.ConfigManager 
except ImportError , err:
    print """Content-type: text/plain\n\n
    Mobyle Internal Error.
    
    Mobyle encountered an internal error:
    The configuration file LOCAL/Config.py is unreachable: %s
    Copy the Example/Local/Config/Config.template.py file to Local/Config/Config.py 
    and edit it to suit your needs (see INSTALL instructions).
    """% err
    sys.exit(1)

import Mobyle.MobyleLogger
Mobyle.MobyleLogger.MLogger()

import Mobyle.MobyleJob 
import Mobyle.Parser 
from Mobyle.MobyleError import *
from Mobyle.SessionFactory import SessionFactory
import Mobyle.Net

_extra_epydoc_fields__ = [('call', 'Called by','Called by')]
_interval = 10

class MbCGI(object):
    """
    This class defines the basic structure of a Mobyle CGI, that should be reused by every CGI in the Portal
    """

    response = {}
    
    request = cgi.FieldStorage()

    c_log = logging.getLogger('mobyle.cgi')
  
    def __init__(self):
        self.osDir = os.path.dirname(__file__)
        self.cfg = Mobyle.ConfigManager.Config()

    def process(self):
        raise NotImplementedError      

    def render(self):
        raise NotImplementedError

class TALCGI(MbCGI):

    template_file = ""
    """name of the template file used for the cache"""
  
    def render(self):
        os.chdir(self.osDir)
        self.context = simpleTALES.Context(allowPythonPath=1)    
        templateFile = open(self.template_file)
        self.template = simpleTAL.compileHTMLTemplate (templateFile)
        templateFile.close()
        self.context.addGlobal ("sitemacros", self.template)
        self.context.addGlobal("options", self.response)
        self.context.addGlobal("self", self)
        html = StringIO.StringIO()
        self.template.expand (self.context, html)
        print "Content-type: text/html\n\n" + html.getvalue()

class XSLCGI(TALCGI):

    xslParams = None
    """parameters used when calling an XSL file for rendering"""
  
    def render(self):
        if hasattr(self,'error_msg'):
          self.template_file="error.html"
          super(XSLCGI, self).render()
        else:
          from Ft.Xml.Xslt.Processor import Processor
          from Ft.Xml.InputSource import DefaultFactory
          from Ft.Xml.Domlette import NoExtDtdReader
          xsltproc = Processor()
          xsltproc.setDocumentReader(NoExtDtdReader)
          xsltproc.appendStylesheet(DefaultFactory.fromUri(self.xsltUri))
          html = xsltproc.run(DefaultFactory.fromUri(self.xmlUrl), topLevelParams=self.xslParams)
          print "Content-type: text/html\n\n" + html

class TextCGI(MbCGI):

    text = ""

    def render(self):
        print "Content-type: text/plain\n\n" + self.text

class JSONCGI(TextCGI):
    
    jsonMap = {}
    
    encoder = None
  
    def render(self):
        import simplejson
        if hasattr(self,'error_msg'):
          self.jsonMap['msg']=self.error_msg
        try:
            print "Content-type: text/plain\n\n" + simplejson.dumps(self.jsonMap, encoding='ascii', cls=self.encoder)
        except UnicodeDecodeError, e:
            try:
                print "Content-type: text/plain\n\n" + simplejson.dumps(self.jsonMap, encoding='utf-8', cls=self.encoder)
            except UnicodeDecodeError, e2:
                try:
                    print "Content-type: text/plain\n\n" + simplejson.dumps(self.jsonMap, encoding='iso-8859-1', cls=self.encoder)
                except UnicodeDecodeError, e3:
                    self.c_log.error("error during json content encoding")

class PNGCGI(MbCGI):

    def render(self):
        print "Content-type: image/png\n\n" + self.pngImage
        
class SessionCGI:

    def __init__(self,cgi):
        self.cgi = cgi
        self.c_log = self.cgi.c_log
        self.request = self.cgi.request

    def process(self):
        self.load_session()
        self.cgi.process()
        
    def render(self):
        self.print_session()
        self.cgi.render()
        
    def load_session(self):
        #self.cgi.resetPortal = False - is resetPortal obsolete?
        # SESSION LOAD
        self.cgi.sessionFactory = SessionFactory(self.cgi.cfg)
        c = Cookie.SimpleCookie(os.environ.get("HTTP_COOKIE"))
        if c.get("sessionKey"):
            self.cgi.sessionKey = c.get("sessionKey").value
        if (hasattr(self.cgi,'sessionKey') and self.cgi.sessionKey):
          try:
              if(c.get("authenticated") and c.get("authenticated").value=="True"):
                  email = Mobyle.Net.EmailAddress( c.get("email").value )
                  self.cgi.session = self.cgi.sessionFactory.getAuthenticatedSession(email,c.get("password").value)            
              else:            
                  self.cgi.session = self.cgi.sessionFactory.getAnonymousSession(self.cgi.sessionKey)
                  # setting the email for the anonymous session
                  if c.get('email') and c.get('email').value:
                      email = Mobyle.Net.EmailAddress( c.get("email").value )
                      self.cgi.session.setEmail(email)
          except MobyleError, errMsg:
              # if the session no longer exists, set session to None (should trigger a reload on the client side when reading the cookie)
              self.cgi.session = None
              self.cgi.sessionKey = None
              #self.cgi.resetPortal = True
              self.c_log.error(errMsg, exc_info=True)
        else:
          # if no session is defined, create one
          if (self.cgi.cfg.anonymousSession()!='no'):
              self.cgi.session = self.cgi.sessionFactory.getAnonymousSession()  
              self.cgi.sessionKey = self.cgi.session.getKey()
          else:
              self.cgi.session = None
              self.cgi.sessionKey = None
        try:
            self.read_session()
        except SessionError, se:
            self.cgi.session = None
            self.cgi.sessionKey = None
            #self.cgi.resetPortal = True
            self.read_session()
                
    def print_session(self):
        self.cgi.response['email'] = self.cgi.email
        print self.__getSessionCookieSetString__()
    
    def read_session(self):
        if self.cgi.session:
            self.cgi.email, self.cgi.authenticated, self.cgi.activated = self.cgi.session.getBaseInfo()
        else:
            self.cgi.email, self.cgi.authenticated, self.cgi.activated = (None, False, False)      
        return

    def __getSessionCookieSetString__(self):
        """
        I{__getSessionCookieSetString__} returns the mobyle session cookie string
        """
        c = Cookie.SimpleCookie()
        #c["resetPortal"]=str(self.cgi.resetPortal)
        if self.cgi.session:
            if self.cgi.sessionKey:
                c["sessionKey"]=str(self.cgi.sessionKey)
            else:
                c["sessionKey"]=''                
            if self.cgi.activated:
                c["activated"]=str(self.cgi.activated)
            else:
                c["activated"]=''
            if self.cgi.email:
                c["email"]=str(self.cgi.email)
            else:
                c["email"]=''
            if self.cgi.authenticated:
                c["authenticated"]=str(self.cgi.authenticated)
            else:
                c["authenticated"]=''
            if(self.cgi.request.getfirst('password')):
                c["password"]=self.cgi.request.getfirst('password')
        else:
            c["sessionKey"]=''
            c["activated"]=''
            c["email"]=''
            c["authenticated"]=''
        return c.output()
