#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.Registry import registry

class NetProgramsList(mb_cgi.JSONCGI):
    """
    This class sends the list of known Mobyle services
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
        for program in registry.programs:
            self.jsonMap[program.name] = {
                                          'url': program.url,
                                          'name': program.server.name,
                                          'installed': program.installed,
                                          'disabled': program.disabled,
                                          'authorized': program.authorized,
                                          'exported': program.isExported()
                                          }

if __name__ == "__main__":
    il = NetProgramsList()
    il.process()
    il.render()