#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import Mobyle.ConfigManager
import urllib # module used to encode the anchors in the menu html page
from Mobyle.Registry import registry
from Mobyle.ClassificationIndex import ClassificationIndex
from Mobyle.SearchIndex import SearchIndex
from Mobyle.DescriptionsIndex import DescriptionsIndex

class ProgramsList(mb_cgi.TALCGI):
    """
    Generates the I{Programs Tree} component

    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    template_file = "programs_list.html"

    def process(self):
      """
      Uses the categories parser to retrieve the tree data
      """
      isInPortal = self.request.getfirst('isInPortal', 'false')

      self.response['filterOn'] = 'false'
      self.response['emptySearchResults'] = 'false'
            
      searchString = self.request.getfirst('searchString',None)
      if searchString:
        si = SearchIndex()
        self.response['filterOn'] = 'true'
        si.filterRegistry(searchString.split(' '))
        if len(registry.programs)==0:
          self.response['emptySearchResults'] = 'true'

      classification = ClassificationIndex()
      DescriptionsIndex().fillRegistry()
      classification.buildRegistryCategories()
      self.response['registry']=registry
      
if __name__ == "__main__":
  pl = ProgramsList()
  pl.process()
  pl.render()