#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi

class SessionCheckCaptcha(mb_cgi.JSONCGI):
    """
    This class checks if the provided captcha answer is right and answers true/false
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    def process(self):
        ok = self.session.checkCaptchaSolution(self.request.getfirst('solution'))
        if not(ok):
            self.jsonMap['msg'] = "Wrong answer, try again"
        self.jsonMap['ok'] = str(ok)

if __name__ == "__main__":
    cc = mb_cgi.SessionCGI(SessionCheckCaptcha())
    cc.process()
    cc.read_session()
    cc.render()