#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.JobFacade import JobFacade
import Mobyle.Net
#import cgitb; cgitb.enable()

class SessionJobSubmit(mb_cgi.JSONCGI):
  """
  JobSubmit is used to submit jobs to a mobyle portal or on the local mobyle portal.
  JobSubmit can:   - submit a job locally and bind it to a local session
                   - forward a job request to a remote execution node and bind the job to the local session
  @author: Herve Menager
  @author: Bertrand Neron
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """

  def process(self):
    self.email = self.request.getfirst('email',None)    
    if self.email:
      self.session.setEmail(Mobyle.Net.EmailAddress( self.email) )
    j = JobFacade.getFromService(self.request.getfirst('programName',None))
    j.create(self.request)
    self.result = j.submit(self.session)
    if self.result.has_key('id') and not(self.result.has_key('errormsg')):
      j.addJobToSession(self.session, self.result)

    
  def render(self):
    render = self.request.getfirst("render","json")
    if render=="text":
      self.text = self.result['id']
      super(mb_cgi.JSONCGI,self).render()
    else:
      self.jsonMap = self.result
      super(SessionJobSubmit,self).render()
    
if __name__ == "__main__":
    js = mb_cgi.SessionCGI(SessionJobSubmit())
    js.process()
    js.read_session()
    js.render()
