#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import Mobyle.Net
from Mobyle.MobyleError import AuthenticationError, SessionError

class SessionRegister(mb_cgi.JSONCGI):
    """
    This class creates an authenticated session, with the specified email
    and password.
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    def process(self):
      try:
          assert self.request.getfirst('email'), "Please provide an e-mail"
          assert self.request.getfirst('password'), "Please provide a password"
          assert self.request.getfirst('password')==self.request.getfirst('passwordCheck'), "The password values you entered need to be identical"
      except AssertionError, ae:
        self.error_msg = str(ae)
        return
      try:
        email = Mobyle.Net.EmailAddress( self.request.getfirst('email') )
        self.anonymousSession = self.session
        self.session = self.sessionFactory.createAuthenticatedSession( email , self.request.getfirst('password') )
        if self.anonymousSession:
            self.session.mergeWith(self.anonymousSession)
        self.sessionKey = self.session.getKey()
        self.jsonMap['ok'] = str(True)
      except SessionError, e:
        self.jsonMap['ok'] = str(False)        
        self.jsonMap['msg'] = str(e)
      
if __name__ == "__main__":
    sr = mb_cgi.SessionCGI(SessionRegister())
    sr.process()
    sr.read_session()
    sr.render()