#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi

class SessionSignOut(mb_cgi.JSONCGI):
    """
    This class signs off an authenticated session, by creating
    a new anonymous session
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    def process(self):
      try:
        if (self.cfg.anonymousSession()!='no'):
          self.session = self.sessionFactory.getAnonymousSession()
          self.sessionKey = self.session.getKey()
        else: 
          self.session = None
          self.sessionKey = None
        self.jsonMap['ok'] = str(True)
      except Exception, e:
        self.jsonMap['ok'] = str(False)        
        self.jsonMap['msg'] = str(e)

if __name__ == "__main__":
    sso = mb_cgi.SessionCGI(SessionSignOut())
    sso.process()
    sso.read_session()
    sso.render()