#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import time
import Mobyle.Utils

class JobsDataList(mb_cgi.JSONCGI):
    """
    This class generates the sent SessionData to the client to construct 
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
      jobsMap = {}
      dataMap = {}
      if self.session:
        tmpjobs = self.session.getAllJobs()
        # sort jobs on their job date
        def jobSort(j1,j2):
          if j1['date']>j2['date']:
            return 1
          if j2['date']>j1['date']:
            return -1
          return 0
        tmpjobs.sort(jobSort)
        for job in tmpjobs:
          if job['date']:
            jobdatestring = time.strftime( "%x  %X", job['date'])
          else:
            jobdatestring = '?'
          job['status'] = str(job['status'])
          jobsMap[job['jobID']] = {'programName': job['programName'] , 'jobDate': jobdatestring , 'status':job['status'] , 'dataUsed': job['dataUsed']}
        data = self.session.getAllData()
        for dataFile in data:
          dataType = dataFile['Type'].getDataType().name
          bioTypes = []
          for bt in dataFile['Type'].getBioTypes():
            bioTypes.append(str(bt))
          userModes = []
          for im in dataFile['inputModes']:
            userModes.append(im)
          dataMap[dataFile['dataName']] = {'userName':dataFile['userName'], 'dataType': dataType, 'bioTypes': bioTypes, 'userModes': userModes, 'title':dataFile['dataBeg'], 'size': '%.2f'%(float(dataFile['size'])/1000), 'format': dataFile['format']}
      self.jsonMap = {'jobs': jobsMap, 'data': dataMap}

if __name__ == "__main__":
    jl = mb_cgi.SessionCGI(JobsDataList())
    jl.process()
    jl.render()
