#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import os
import time
import datetime
import Mobyle.ConfigManager
import Mobyle.Utils
import urllib # module used to encode the anchors in the menu html page
from Mobyle.Registry import registry

class SiteMap(mb_cgi.TALCGI):
    """
    Generates the SiteMap used for robots indexing

    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    template_file = "sitemap.xml"

    def process(self):
      """
      Uses the categories parser to retrieve the tree data
      """

      csl = []
      for program in registry.programs:
        try:
            cs = {}
            cs['name'] = program.name
            # the date below is in utc time, with no local time handling so that we do not have to import additional modules
            cs['mtime'] = datetime.datetime.utcfromtimestamp(os.path.getmtime(program.path)).isoformat() + '+00:00'
            csl.append(cs)
        except OSError, oe:
            pass
      self.response['baseurl'] = self.cfg.cgi_url()+'/portal.py'
      self.response['programs'] = csl
      
if __name__ == "__main__":
  pl = SiteMap()
  pl.process()
  pl.render()