
########################################################################################
#                                                                                      #
#   Author: Bertrand Neron,                                                            #
#   Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.   #  
#   Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.         #
#                                                                                      #
########################################################################################


"""
Classes executing the command and managing the results  
"""
import os 
import time

import logging 
_log = logging.getLogger(__name__)

import Mobyle.ConfigManager

import Local.Policy
from Mobyle.MobyleError import *


_cfg = Mobyle.ConfigManager.Config()
__extra_epydoc_fields__ = [('call', 'Called by','Called by')]



class _Batch:
    """
    abstract class
    manage the status by updating the file index.xml
    """

    def __init__( self , commandLine , dirPath , serviceName , jobState = None , xmlEnv = None ):
        """
        @param commandLine: the command to be executed
        @type commandLine: String
        @param dirPath: the absolute path to directory where the job will be executed (normaly we are already in)
        @type dirPath: String
        @param serviceName: the name of the service
        @type serviceName: string
        @param jobState:
        @type jobState: a L{JobState} instance
        @call: L{Script.__init__}

        """
        self.commandLine = commandLine
        
        self._protectedCommandLine = ''
        for c in self.commandLine:
            self._protectedCommandLine += '\\'+ c
        self.dirPath = dirPath
        self.serviceName = serviceName
        if not jobState :
            self.jobState = Mobyle.JobState.JobState( self.dirPath )
        self._adm = Mobyle.Utils.Admin( self.dirPath )
        if xmlEnv:
            self.xmlEnv = xmlEnv
        else:
            self.xmlEnv = {}
            
        # queue is a dictionary
        queue = _cfg.queue( self.serviceName )
        self.queue = Local.Policy.queue( queue["queue"] )

        new_path = ''
        binary_path = _cfg.binary_path()
        if binary_path :
                new_path = ":".join( binary_path )        
        if self.xmlEnv.has_key( 'PATH' ) :      
                new_path = "%s:%s" %( self.xmlEnv[ 'PATH' ] , new_path )
        if new_path :
            self.xmlEnv[ 'PATH' ] = "%s:%s" %( new_path , os.environ[ 'PATH' ] ) 
        else:
            self.xmlEnv[ 'PATH' ] = os.environ[ 'PATH' ] 
        for var in os.environ.keys():
            if var != 'PATH':
                self.xmlEnv[ var ] = os.environ[ var ]
        self._returncode = None
        accounting = _cfg.accounting()
        if accounting:
            beg_time = time.time()

        ###################################
        mobyleStatus = self.run()
        ###################################
        
        if accounting:
            end_time = time.time()
            elapsed_time = end_time - beg_time
            a_log = logging.getLogger( 'Mobyle.account' )
            #%d trunc time to second
            #%f for millisecond
            a_log.info("%s/%s %d-%d %d %s" %( serviceName ,
                                           _cfg.batch( serviceName ) ,
                                           beg_time ,
                                           end_time ,
                                           elapsed_time ,
                                           self._returncode 
                                           )
                       )
        self.jobState.setStatus( mobyleStatus )
        self.jobState.commit()
        adm = Mobyle.Utils.Admin( self.dirPath )
        adm.setStatus( mobyleStatus  )
        adm.commit()


    def getKey( self ):
        """
        extract the Job key from the dirPath
        """
        if self.dirPath[-1] == '/':
            self.dirPath = self.dirPath[:-1]
        return os.path.split( self.dirPath )[1]
    
    def run( self ):
        """
        run the job
        abstract method. this method must be implemented in child classes
        """
        raise NotImplementedError, "Must be Implemented in child classes"

    @staticmethod
    def getStatus( number ):
        """
        @param number:
        @type number:
        @return the status of the job
        @rtype:
        abstract method. this method must be implemented in child classes
        """
        raise NotImplementedError, "Must be Implemented in child classes"

    @staticmethod
    def kill( self , number ):
        """
        kill the Job
        @param number:
        @type number:
        abstract method. this method must be implemented in child classes
        """
        raise NotImplementedError, "Must be Implemented in child classes"
            
    def _logError( self , admMsg = None , userMsg = None , logMsg = None ):

        if  admMsg :
            adm = Mobyle.Utils.Admin( self.dirPath )
            adm.setStatus( Mobyle.Utils.Status( code = 5 , message = admMsg ) )
            adm.commit()

        if userMsg :
            self.jobState.setStatus( Mobyle.Utils.Status( code = 5 , message = userMsg ) )
            self.jobState.commit()

        if logMsg :
            _log.error( "%s/%s : %s" %( self.serviceName ,
                                          self.getKey() ,
                                          logMsg
                                          )
                        )
          
          
          
          
