<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- 
  mobyle.xsl stylesheet
  Contains shared rules between the different portal xsl stylesheets
  Authors: Herv Mnager, Bertrand Nron
-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">
    <!-- Depending on isInPortal, we either print a whole html document, or just its body -->
    <xsl:choose>
      <xsl:when test="$isInPortal!='true'">
        <html xmlns="http://www.w3.org/1999/xhtml" lang="en"
          xml:lang="en">
          <!-- TODO update all CSS links -->
          <head>
          	<!-- here we compute the path to the css stylesheets dir, based on the href pseudo-attribute of the XSL processing instruction -->
          	<xsl:variable name="xslUri" select="translate(substring-before(substring-after(processing-instruction('xml-stylesheet'), 'href='), ' '),'&quot;','')" />
          	<xsl:variable name="cssBase" select="concat(substring-before($xslUri, '/xsl'),'/css/')" />
            <style type="text/css">
              @import "<xsl:value-of select='$cssBase' />mobyle.css"; 
            </style>
            <xsl:apply-templates select="/" mode="head" />
          </head>
          <body>
            <xsl:apply-templates />
          </body>
        </html>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="popups">
    <!-- name: either a program name or a job id -->
    <xsl:param name="popupName"/>  
    <!-- popups overlay -->
	<div class="popup_overlay" style="display: none;">
	  <xsl:attribute name="id">
		<xsl:value-of select="concat($popupName,'PopupOverlay')" />        
	  </xsl:attribute>
	  <span class="popup_background" />
	  <span class="popup" style="display: none;">
    	<xsl:attribute name="id">
	      <xsl:value-of select="concat($popupName,'Popup')" />        
	    </xsl:attribute>
		<div>
	      <!-- form submission wait box -->
	      <span style="display:none">
	        <xsl:attribute name="id">
	        	<xsl:value-of select="concat($popupName,'GenericWait')" />
	        </xsl:attribute>
	        <div class="message">Please wait.</div>
            <div class="loading" alt="Loading" />
	      </span>
	      <!-- help mail popup -->
	      <form action="help_request.py" style="display:none">
	        <xsl:attribute name="id">
	        	<xsl:value-of select="concat($popupName,'JobHelpForm')" />
	        </xsl:attribute>
	        <xsl:attribute name="name">        
	        	<xsl:value-of select="concat($popupName,'JobHelpForm')" />
	        </xsl:attribute>
	        <div><strong>Help on your job</strong></div>
	        <div><em>(<xsl:value-of select="$popupName" />)</em></div>
	        <div>You can request help from the support team of this server. Please describe your problem here, and remember to describe your problem <em>precisely</em>, using <em>complete sentences</em>:</div>
	        <div>
		        <input type="hidden" name="id">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'JobHelpId')" />
	              </xsl:attribute>
		        </input>
		        <input type="hidden" name="date">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'JobHelpDate')" />
	              </xsl:attribute>
		        </input>
		        <input type="hidden" name="status">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'JobHelpStatus')" />
	              </xsl:attribute>
		        </input>
		        <input type="hidden" name="errorparam">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'JobHelpErrorParam')" />
	              </xsl:attribute>
		        </input>
		        <input type="hidden" name="errormsg">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'JobHelpErrorMsg')" />
	              </xsl:attribute>
		        </input>		        
	        	<label class="mandatory" for="helpEmail">
				  your e-mail:
	        	</label>
		        <input type="text" name="helpEmail">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'JobHelpEmail')" />
	              </xsl:attribute>
		        </input>
			</div>
	    	<label class="mandatory" for="helpMessage">
			  describe your problem:
	    	</label>
	        <textarea cols="70" rows="15" name="helpMessage">
	        </textarea>
	        <div>
	            <input type="button" value="Cancel">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'JobHelpCancel')" />
	              </xsl:attribute>
	            </input>
	            <input type="submit" value="Send">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'JobHelpSubmit')" />
	              </xsl:attribute>
	            </input>
	        </div>
	      </form>
	      <!-- help message confirmation -->
	      <span style="display:none">
	        <xsl:attribute name="id">
			  <xsl:value-of select="concat($popupName,'HelpConfirmationBox')" />
	        </xsl:attribute>
	        <xsl:attribute name="name">
	          <xsl:value-of select="concat($popupName,'HelpConfirmationBox')" />
	        </xsl:attribute>
	        <strong>Your message has been sent.</strong>
	        <div>Message text:</div>
	        <textarea cols="70" rows="15">
	          <xsl:attribute name="id">
	            <xsl:value-of select="concat($popupName,'HelpConfirmationMessage')" />
	          </xsl:attribute>
	        </textarea>
	        <input type="button" value="Ok">
	          <xsl:attribute name="id">
	            <xsl:value-of select="concat($popupName,'HelpConfirmationOk')" />
	          </xsl:attribute>
	        </input>
	      </span>
	      <!-- job removal popup -->
	      <form action="session_job_remove.py" style="display:none">
	        <xsl:attribute name="id">
	        	<xsl:value-of select="concat($popupName,'RemoveJobForm')" />
	        </xsl:attribute>
	        <xsl:attribute name="name">        
	        	<xsl:value-of select="concat($popupName,'RemoveJobForm')" />
	        </xsl:attribute>
	        <strong>Job removal</strong>
	        <div>This will remove this job from your session. Continue?</div>
	        <input type="hidden" name="id">
	          <xsl:attribute name="value">
	            <xsl:value-of select="$popupName" />
	          </xsl:attribute>
	        </input>
	        <div>
	            <input type="button" value="Cancel">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'RemoveJobCancel')" />
	              </xsl:attribute>
	            </input>
	            <input type="submit" value="Remove">
	              <xsl:attribute name="id">
	                <xsl:value-of select="concat($popupName,'RemoveJobSubmit')" />
	              </xsl:attribute>
	            </input>
	        </div>
	      </form>
	      <!--[if lte IE 6.5]><iframe></iframe><![endif]-->
        </div>
      </span>
    </div>
  </xsl:template>

  <xsl:template name="askHelpPopUpButton">
    <!-- name: either a program name or a job id -->
    <xsl:param name="popupName"/>  
    <input type="button" style="display:none" value="ask for help">
      <xsl:attribute name="id"><xsl:value-of select="concat($popupName,'JobHelpOpen')" /></xsl:attribute>
    </input>
  </xsl:template>

  <xsl:template name="removeJobButton">
    <!-- name: either a program name or a job id -->
    <xsl:param name="popupName"/>  
    <input type="button" style="display:none" value="remove this job">
      <xsl:attribute name="id"><xsl:value-of select="$popupName" />RemoveJobOpen</xsl:attribute>
    </input>
  </xsl:template>
  
  <xsl:template name="commentText">
    <xsl:param name="commentNode"/>
    <xsl:param name="exampleNode"/>
		<xsl:choose>
	    <xsl:when test="($commentNode/text) or $exampleNode">
	      <ul class="commentText" style="display: none">
	        <xsl:attribute name="id">
	          <xsl:if test="$commentNode and not($exampleNode)">
		        <xsl:value-of select="concat($programUri,'#',generate-id($commentNode))" />
			  </xsl:if>
	          <xsl:if test="$exampleNode">		  
		        <xsl:value-of select="concat($programUri,'#',generate-id($exampleNode))" />
			  </xsl:if>
	        </xsl:attribute>        
	        <xsl:for-each select="$commentNode/text">
	          <li><xsl:value-of select="text()"/></li>
	        </xsl:for-each>
	        <xsl:if test="string-length($exampleNode)>0">
	          <div class="example">Example data:
		        <pre><xsl:value-of select="$exampleNode"/></pre>
			  </div>
	        </xsl:if>
	      </ul>
	    </xsl:when>
			<xsl:when test="($commentNode)">
			  <div class="commentText" style="display: none">
		        <xsl:attribute name="id">
		          <xsl:value-of select="concat($programUri,'#',generate-id($commentNode))" />
				</xsl:attribute>		  	
			    <xsl:copy-of select="$commentNode" />		  	
			  </div>
			</xsl:when>		
		</xsl:choose>
  </xsl:template>  

  <xsl:template name="commentToggle">
    <xsl:param name="commentNode"/>  
    <xsl:param name="exampleNode"/>
    <xsl:if test="($commentNode) or $exampleNode">
      <label class="commentToggle">
        <xsl:attribute name="for">
          <xsl:if test="$commentNode and not($exampleNode)">
	        	<xsl:value-of select="concat($programUri,'#',generate-id($commentNode))" />
		  		</xsl:if>
          <xsl:if test="$exampleNode">		  
	        	<xsl:value-of select="concat($programUri,'#',generate-id($exampleNode))" />
		  		</xsl:if>
        </xsl:attribute>        
        <xsl:attribute name="title">Click here to get help on this parameter</xsl:attribute>
        <xsl:value-of select="'?'"/>
      </label>
    </xsl:if>            
  </xsl:template>
  
    <xsl:template match="layout">
    <xsl:choose>
      <xsl:when test="name(..)='hbox'">
          <td>
            <table>
                <xsl:apply-templates select="*" />                    
            </table>
          </td>        
      </xsl:when>
      <xsl:when test="name(..)='vbox'">
        <tr>
          <td>
            <table>
                <xsl:apply-templates select="*" />                    
            </table>
          </td>        
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <table>
            <xsl:apply-templates select="*" />                    
        </table>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="hbox">
    <tr>
      <xsl:apply-templates select="*" />                    
    </tr>
  </xsl:template>

  <xsl:template match="vbox">
    <xsl:apply-templates select="*" />                    
  </xsl:template>


  <xsl:template match="box">
    <xsl:choose>
      <xsl:when test="name(..)='hbox'">
          <td>
            <xsl:apply-templates select="//parameter[name/text()=current()/text()]" />                    
          </td>        
      </xsl:when>
      <xsl:when test="name(..)='vbox'">
        <tr>
          <td>
            <xsl:apply-templates select="//parameter[name/text()=current()/text()]" />                    
          </td>        
        </tr>
      </xsl:when>      
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="substring-after-last">
    <xsl:param name="string" />
    <xsl:param name="delimiter" />
    <xsl:choose>
      <xsl:when test="contains($string, $delimiter)">
        <xsl:call-template name="substring-after-last">
          <xsl:with-param name="string" select="substring-after($string, $delimiter)" />
          <xsl:with-param name="delimiter" select="$delimiter" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="$string" /></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="string-or-join"><!-- replaces the missing xpath 2.0 string-join function -->
    <xsl:param name="nodeSet" />
    <xsl:for-each select="$nodeSet">
	    <xsl:value-of select="."/>
	    <xsl:if test="position() != last()">
	      <xsl:text> or </xsl:text>
	    </xsl:if>
	    <xsl:if test="position() = last()">
	      <xsl:text> </xsl:text>
	    </xsl:if>	    
    </xsl:for-each>
  </xsl:template>
  
  <!-- display parameter type -->
  <xsl:template match="type">
	  <xsl:text> (</xsl:text>
      <xsl:call-template name="string-or-join">
        <xsl:with-param name="nodeSet" select="biotype"/>
      </xsl:call-template><xsl:text />
      <xsl:value-of select="datatype/class" />
      <xsl:text>)</xsl:text>
  </xsl:template>

</xsl:stylesheet>