
########################################################################################
#                                                                                      #
#   Author: Bertrand Neron,                                                            #
#   Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.   #  
#   Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.         #
#                                                                                      #
########################################################################################


"""
Classes executing the command and managing the results  
"""
import os ,os.path
from subprocess import Popen, PIPE

import logging
_log = logging.getLogger(__name__)

import Mobyle.JobState
import Mobyle.ConfigManager
import Mobyle.Utils
from Mobyle.Execution.Batch import _Batch

import Local.Policy
from Mobyle.MobyleError import *


_cfg = Mobyle.ConfigManager.Config()
__extra_epydoc_fields__ = [('call', 'Called by','Called by')]




class Dummy(_Batch):
    """
    Run the commandline by a system call
    """

    def run(self):
        """
        Run the commandLine 
        redirect the standard error and output on service.name.out and service.name.err, then restore the sys.stderr and sys.stdout
        @return: the L{Mobyle.Utils.Status} of this job and a message
        @rtype: Status
        @call: in _Batch.__init__
        """
        if (os.getcwd() != os.path.abspath(self.dirPath) ):
            msg = "the process is not in the working directory"

            self._logError( admMsg = msg ,
                            userMsg = "Mobyle internal server error" ,
                            logMsg = msg )

            raise MobyleError , msg

        else:
            
            jobKey = self.getKey()
            fout = open( self.serviceName + ".out" , 'w' )
            ferr = open( self.serviceName + ".err" , 'w' )

            try:
                ## execute the commandline through your favorite execution system
                pass
            except OSError, err:
                msg= "System execution failed: " + str(err)

                self._logError( admMsg = msg ,
                                userMsg = "Mobyle internal server error" ,
                                logMsg = None )
                
                _log.critical( "%s/%s : %s" %( self.serviceName ,
                                                   jobKey ,
                                                   msg
                                                   )
                                 )

                raise MobyleError , msg 
                
            
            self._adm.setBatch( 'DUMMY' )  ## store the name of execution sytem used for this job 
            self._adm.setNumber( job_key ) ## store the a key to query/retrieve this job on this system execution
            self._adm.commit()

            ## link the .admin file in ADMINDIR which looklike to a "process table"
            linkName = ( "%s/%s.%s" %( _cfg.admindir() ,
                                       self.serviceName ,
                                       jobKey
                                    )
                         )
            
            try:
                os.symlink(
                    os.path.join( self.dirPath , '.admin') ,
                    linkName
                    )
            except OSError , err:
                msg = "can't create symbolic link %s in ADMINDIR: %s" %( linkName , err )

                self._logError( admMsg = msg ,
                                userMsg = "Mobyle internal server error" ,
                                logMsg = None )
                
                _log.critical( "%s/%s : %s" %( self.serviceName ,
                                                   self.getKey() ,
                                                   msg
                                                   )
                                 )

                raise MobyleError , msg

            
            ## wait the completion of the job 
            ## THIS CLASS MUST BE SYNCHRON WITH THE JOB  
            

            try:
                ## remove the job from the ADMINDIR ( "process table" )
                os.unlink( linkName )
            except OSError , err:
                msg = "can't remove symbolic link %s in ADMINDIR: %s" %( linkName , err )

                self._logError( admMsg = msg ,
                                userMsg = "Mobyle internal server error" ,
                                logMsg = None )
                
                _log.critical( "%s/%s : %s" %( self.serviceName ,
                                                   self.getKey() ,
                                                   msg
                                                   )
                                 )

                raise MobyleError , msg
            ##close the standard output and standard error file
            fout.close()
            ferr.close()
            
            self._adm.refresh()
            oldStatus = self._adm.getStatus()
 
            #if the oldStatus is terminal ( finish error killed )
            #I don't modify this status 
            if oldStatus.isEnded():
                return oldStatus
            else:
                ## analyse the returncode of the job
                ## and instanciate a Status according the returncode
                ## then return the Status
                status = Mobyle.Utils.Status( code = 4 ) #finished
            return status
        

    @staticmethod
    def getStatus( key ):
        """
        @param key: the value associate to the key "NUMBER" in Admin object (and .admin file )
        @type key: string
        @return: the status of the job corresponding to the key 
        @rtype: Mobyle.Utils.Status instance
        @call: by L{Utils.getStatus}
        """
        ##query your execution system about the job with this key
        ##translate the answer in mobyle compliant status and message
        
        ## for mobyle status see Mobyle.Utils.Status
        mobyle_status_code = 4 # running
        message = "my job is running"
        return Mobyle.Utils.Status( code = mobyle_status_code , message = message )


    @staticmethod
    def kill( key ):
        """
        kill a job
        @param key : the value associate to the key "NUMBER" in Admin object (and .admin file )
        @type key: string
        @raise MobyleError: if can't kill the job
        @call: by L{Utils.Mkill}
        """

        return
        
