import os , os.path
# this a python module the syntax used is the python syntax


############################################
#                                          #
#            Mandatory values              #
#                                          #
############################################


# the root url of mobyle 
ROOT_URL = "http://marygay.sis.pasteur.fr:82"

MOBYLEHTDOCS = '/home/bneron/Mobyle/trunk/web/htdocs' # necessaire pour les Mobyle "non installes"

HTDOCS_PREFIX = ''

CGI_PREFIX = 'cgi-bin'

#########
#       #
# mails #
#       #
#########

#a list of email adresses who will recieved messages when problems occur
MAINTAINER = [ "bneron@pasteur.fr" ]

#the meail address where the user could ask some help
HELP="bneron@pasteur.fr"

# local mailhost
MAILHOST= "localhost"

##################
#                #
# queuing system #
#                # 
##################

from Execution import  *
EXECUTION_SYSTEM_ALIAS = {
                          'DRMAA_sge'   : SgeDRMAAConfig( '/usr/local/sge/lib/lx26-amd64/libdrmaa.so' , 
                                                          root = '/usr/local/sge', 
                                                          cell = 'default' ) ,
                          'DRMAA_torque': PbsDRMAAConfig( '/usr/local/lib64/libdrmaa.so' , 
                                                          'marygay.sis.pasteur.fr' ),
                          'SGE'         : SGEConfig( root = '/usr/local/sge', 
                                                     cell= 'default' ) ,
                          'SYS'         : SYSConfig() , 
                          'LSF'         : LsfDRMAAConfig( '/home/bneron/Sys/lib/libdrmaa.so' ,  
                                                          lsf_envdir = '/home/bneron/Sys/share/lsf/conf' ,
                                                          lsf_serverdir = '/home/bneron/Sys/share/lsf/7.0/linux2.6-glibc2.3-x86_64/etc')
                          }

from Mobyle.Dispatcher import DefaultDispatcher

DISPATCHER = DefaultDispatcher( { 
                                  'sge_drmaa_sleep' : ( EXECUTION_SYSTEM_ALIAS[ 'DRMAA_sge' ] , 'mobyle' ),
                                  'pbs_drmaa_sleep' : ( EXECUTION_SYSTEM_ALIAS[ 'DRMAA_torque' ] , 'mobyle' ),
                                  #'toppred'   : ( EXECUTION_SYSTEM_ALIAS[ 'DRMAA_torque' ] , 'short' ),
                                  'lsf_drmaa'  : ( EXECUTION_SYSTEM_ALIAS[ 'LSF' ] , 'mobyle' ),
                                  'sge_sleep' : ( EXECUTION_SYSTEM_ALIAS[ 'SGE' ]    , 'long' ),
                                  'golden'    : ( EXECUTION_SYSTEM_ALIAS[ 'DRMAA_sge' ]    , 'mobyle' ),
                                  'DEFAULT'   : ( EXECUTION_SYSTEM_ALIAS[ 'SYS' ]          , '' )
                           } )

#######################
#                     #
#       logging       #
#                     #
#######################

#the directory were will stored the log files
LOGDIR = '/var/log/mobyle/dev'


####################################################
#                                                  #
#    programs needed by the sequences format       #
#          detection and conversion                # 
#                                                  #
####################################################

# the 2 sequences conveter supported by Mobyle are
# squizz and the java version of readseq
# squizz is HIGHLY recommanded

from Mobyle.Converter import *

DATA_CONVERTER={
      'Sequence': [ squizz_sequence('/local/gensoft/bin/squizz') ] ,
      'Alignment': [ squizz_alignment('/local/gensoft/bin/squizz')]
                }

#DATA_CONVERTER={
#       'Sequence': [
#                    squizz_sequence('/usr/local/bin/squizz'),
#                    iANTConverter()
#                    ] ,
#       'Alignment': [ squizz_alignment('/usr/local/bin/squizz')],
#       'iANTEntryDBReport': [ iANTConverter()],
#       'iANTEntryReport': [iANTConverter()],
#       'iANTReport':[iANTConverter()]
#                  }
 
          ############################################################# 
          ##                                                         ##
          ##                    Optionals Values                     ##
          ##                                                         ##
          #############################################################


#########
#       #
# Debug #
#       #
#########

#used in production
# 0    - the command line is build
#      - the build log is NOT fill
#      - the job is executed

#to test a xml ( python syntax in code , precond ... )
# 1    - the command line is build 
#      - the build log is NOT fill
#      - the job is NOT excuted

#to know what's wrong in the xml I wrote.
# 2    - the command line is build
#      - the build log is fill
#      - the job is NOT executed

#to test the xml and the job execution and the results retrieving
# 3    - the command line is build
#      - the build log is fill
#      - the job is executed

DEBUG = 3

#to set a different debug level for a particular service
PARTICULAR_DEBUG = { 'InterProScan' : 2 ,
                     'InterProScan_go': 2,
                     'SeqLogo' :2  }


###############
#             #
# Directories #
#             #
###############

# were are the binary corresponding to the services
# a list of string
# each element must be a valid path
# the element order is kept to build the final PATH ( the binary path is add before the canonical PATH )
BINARY_PATH = [ "/home/bneron/Sys/bin", "/usr/bin" , "/usr/local/bin" , "/local/gensoft/scripts", "/local/gensoft/bin" ]

#the path to the golden binary 
#je squizz le warpper gensoft ( j'ai rajoute GOLDENDATA dans l'env apache
#sinon il faudrait avoir gensoft/scripts et bin dans le path apache et donc hacker le scrit de demarrage d'apache


DATABANKS_CONFIG = {
    'embl':{
            'dataType' : 'Sequence' ,
            'bioTypes' : ['Nucleic'] ,   
            'label'    : 'EMBL Nucleotide Sequence Database',
            'command'  : ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
            },
    'genbank':{
               'dataType' : 'Sequence',
               'bioTypes' : ['Nucleic'],
               'label'    : 'Genbank NIH DNA sequence database',
               'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
               },
    'genpept':{ 
               'dataType' : 'Sequence',
               'bioTypes' : ['Protein'],   
               'label'    : 'Genbank Translated Protein-coding Sequences',
               'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
               },
    'imgt':{
            'dataType' : 'Sequence',
            'bioTypes' : ['Nucleic'],   
            'label'    : 'IMGT - ImMunoGeneTics sequence database',
            'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
            },
    'refseq':{
              'dataType' : 'Sequence',
              'bioTypes' : ['Nucleic' , 'Protein'],    
              'label'    : 'NCBI Reference Sequence (RefSeq) Database',
              'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
    },
    'uniprot':{ 
               'dataType' : 'Sequence', 
               'bioTypes' : ['Protein'], 
               'label'    : 'UniprotKB - Universal Protein Knowlege Base',
               'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
    },
    'wgs':{
           'dataType' : 'Sequence', 
           'bioTypes' : ['Nucleic'],    
           'label'    : 'Genbank - Whole Genome Shotgun',
           'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
    },
    'pdb':{
           'dataType':'3DStructure', 
           'bioTypes':['Protein'], 
           'label': 'Protein Data Bank', 
           'command': [ "/path/to/PDBGet.py", "%(id)s" ]
    }
    }


#PREVIEW_DATA_LIMIT =  1048576 
######################
#                    #
#   Authentication   #
#                    #
######################


# to make email optional for all programs, set this to True
# default value = True
#OPT_EMAIL = False
OPT_EMAIL = False
# to have a more control on the mandatory email
# it able to have the general option but
# it could be set to another value for particular service
# exemple :
# OPT_EMAIL could be set at False ( the email is mandatory )
# but set a True for some very short services.

PARTICULAR_OPT_EMAIL = {'golden' : True }

#anonymous session there is 3 available values 
# no      : the anonymous sessions are not allowed
# yes     : the anonymous sessions are allowed, without any verification 
# captcha : the anonymous sessions are allowed, but with a captcha challenge ( default )
#ANONYMOUS_SESSION = "captcha"


#authenticated session there is 3 available values
# 'no'    : the authenticated session are not allowed.
# 'yes'   : the authenticated session are allowed and activated without any restriction.
# 'email' : the authenticated session are allowed but an email confirmation is needed to activate it (default).

#AUTHENTICATED_SESSION = "email"
#AUTHENTICATED_SESSION = 'yes'

##############
#            #
#    misc    #
#            #
##############

#the time to consider that a job is long ( in sec default = 60 )
#TIMEOUT = 120

# refresh frequency for user data in the web portal, in seconds
# default: 240
#REFRESH_FREQUENCY = 240

# max size for any file (2 Go )
#FILELIMIT = 2147483648

# max size for a session in bytes ( default = 50Mo = 52428800 )
#SESSIONLIMIT = 52428800 
SESSIONLIMIT = 1048576

#max size to preview the results 
#if the results size exceed this limit the results appear as a link ( default value = 1048576 = 1Mib )
#PREVIEW_DATA_LIMIT=1048576

#number of "identical" jobs a user is allowed to submit at a given time.
#identical means same email, same command line. ( default = 1 )
#0 disable this control, then the user may submit as many time he wants the "same" job.
#if the email is not provided (depend of the configuration) this control is disabled.    
SIMULTANEOUS_JOBS = 2

#WELCOME_CONFIG to configuer the welcome page of the portal
#WELCOME_CONFIG is a dictionnary with 2 entries:
#  -'format': with 2 avalaible values:
#                      - 'html' if the url point out an html page
#                      - 'atom' if the url point out an file in atom format
#    -'url' : point toward rthe document to include in the portal welcome page
               
WELCOME_CONFIG= { 'format': 'html' ,
                  'url': 'http://marygay.sis.pasteur.fr:82/portal/welcome_page.html'
                 }
##########
#        #
#  Mail  #
#        #
##########

#from: sender email adresse ( default = HELP )
SENDER = "mobyle-noreply@pasteur.fr"

#set this True if you don't want results to be sent by email.
#This does not make email optional
#DONT_EMAIL_RESULTS = False

# max size for results by email ( in bytes default 2 Mib )
#MAXMAILSIZE = 2097152

# how long should results be available on the server ( in days default = 10)?
#RESULT_REMAIN = 10

EMAIL_DELAY = 0

# if you want to resolv the domain name of the user email
# and if it has a mail exchanger field
# (to avoid fake user email address)
# by default DNS_RESOLVER = False
# if DNS_RESOLVER = True dnspython must be installed

DNS_RESOLVER = False
#DNS_RESOLVER = True


################
#              #
#   logging    #
#              #
################

# to monitored the elapsed time per job ( default = False )
#ACCOUNTING = True
SESSION_DEBUG= True
#######################
#                     #
# disabling services  #
#                     #
#######################

## some times you need to disable the portal for maintaining operation etc...
## if DISABLE_ALL is True no new job could be submit, but the running job keep running

#DISABLE_ALL = False

## To disable specifically one service (program or workflow) from any portal, you can append it in  DISABLED_SERVICES.
## joker can be used, so it's easy to disable all services from a given portal.
## this portal is call 'local'
## to re-enable services just toggle DISABLE_ALL to False or remove it from 
## the DISABLED_SERVICES list
## example:
##DISABLED_SERVICES = [ 'portal1.service1' , # disable the service1 from the imported portal1 (as defined in PORTALS )
##                      'portal2.*' ,        # disable all services from the imported portal2
##                      'local.clustalw*'    # disable all services begining by clustalw (clutalw-multialign ,clustalw-sequence , clustalw-profile ) from this server.
##                     ] 
## By default all services are enabled

#DISABLED_SERVICES = [ 'local.dna*' ] 

################################
#                              #
# restriction services access  #
#                              #
################################


#AUTHORIZED_SERVICES = {'dssp' : [ '157.99.60.92'] }


# serviceName : [ ip , ip mask ]

# the ip address which can use the service
# ip syntax
#
# 'toppred' : [ '125.234.60.18' , # only the machine with this ip could acces to toppred
#               '125.234.60.*'  , # all the machines in subnet could acces to toppred
#               '125.234.*.15   , # all the machine 
#             ] 
#
# if there is no entry for a service it's mean that
# every body can acces to this service


################################
#                              #
#     Services Management      #
#                              #
################################

##################################################################################
#                                                                                #
# Local program publishing section                                               #
#                                                                                #
# This configuration file is used to deploy the xml services descriptions on     # 
# the Mobyle web part from the Local/Services/* and /Srevices/* directories.     # 
# all the xml from Local/Services/*/* are deployed                               #
# the xml from Services/*/* are filtered following the rules below               #  
# (for more explanations see INSTALL notes and Tools/README)                     #
#                                                                                #
# (if this file doesn't exist all the programs from Programs will be published)  # 
#                                                                                #
##################################################################################

LOCAL_DEPLOY_INCLUDE = { 'programs' : [ '*' ] ,
                          'workflows': [ '*' ] ,
                          'viewers'  : [ '*' ] ,
                          }

LOCAL_DEPLOY_EXCLUDE = { 'programs' : [ '' ] ,
                          'workflows': [ '' ] ,
                          'viewers'  : [ '' ] ,
                          }

######################
#                    #
#    Grid aspects    #
#                    #
######################
PORTAL_NAME = "marygay-dev"
PORTALS={
        'MobyleProd': {
                       'url': 'http://mobyle-prod.pasteur.fr/cgi-bin/',
                       'help' : 'bneron+Mobyle-prod@pasteur.fr',
                       'repository': 'http://mobyle-prod.pasteur.fr/', #avant http://mobyle.rpbs.univ-paris-diderot.fr/data/programs
                       'services': { 'programs' :[ 'golden', 'hmmbuild'  , 'pars', 'protpars', 'mix', 'fastdnaml', 'phyml', 'puzzle', 'bambe', 'clique', 'drawgram' , 'drawtree', 'wise2',],
                                    }
                   },
                   
        'rita': {
                       'url': 'http://rita.sis.pasteur.fr:85/cgi-bin/',
                       'help' : 'hmenager+marygay@pasteur.fr',
                       'repository': 'http://rita.sis.pasteur.fr:85/', #avant http://mobyle.rpbs.univ-paris-diderot.fr/data/programs
                       'services': { 'programs' :[ 'toppred' , 'abiview' ],
                                    }
                   },   
             
#        'server2':{
#                   'url': 'http://mobyle.server2.fr/cgi-bin',
#                   'help' : 'foo@bar.org',
#                   'repository': 'http://mobyle.server2.fr', #avant http://mobyle.rpbs.univ-paris-diderot.fr/data/programs
#                   'services': { 'programs' :[ 'programs_server1_1' ],
#                                'workflows':[ 'workflow_server1_1' ]
#                                }
#                   },
#        'rpbs': {
#            'url': 'http://mobyle.rpbs.univ-paris-diderot.fr/cgi-bin',
#            'help' : 'pierre.tuffery@univ-paris-diderot.fr',
#            'repository': 'http://mobyle.rpbs.univ-paris-diderot.fr/', #avant http://mobyle.rpbs.univ-paris-diderot.fr/data/programs
#            'services': { 'programs' :[ 'stride' , 'Frog' , 'XMLBlastSeq' ],
#                          'workflows':[ 'trucmuche' ]
#                        }
#                } ,
#        'LIPM': {
#           'url': 'http://lipm-bioinfo.toulouse.inra.fr/Mobyle/MobylePortal/cgi-bin',
#           'help': 'sebastien.carrere@toulouse.inra.fr',
#           'repository': 'http://lipm-bioinfo.toulouse.inra.fr/Mobyle/MobylePortal',# avant http://lipm-bioinfo.toulouse.inra.fr/Mobyle/MobylePortal/programs'
#           'services': {
#                        'programs' : ['HeliageneGetSequence','iANTMultalinProteic','iANTMultalinNucleic','InterproAnnotation','SeqLogo','iANTPatScan'],
#           }
#           }

       }

EXPORTED_SERVICES = [ 'protpars' , 
                      'dnapars' ,
                      'toppred' , 
                      'golden', 
                      'dssp',
                      'gruppi',
                      'boxshade',
                      'mfold',
                      'workflow_phylogeny',
                      'hmmbuild',
                     ]


