import os , os.path
# this a python module the syntax used is the python syntax

##################################
#
# Debug
#
#################################

#used in production
# 0    - the command line is build
#      - the build log is NOT fill
#      - the job is executed

#to test a xml ( python syntax in code , precond ... )
# 1    - the command line is build 
#      - the build log is NOT fill
#      - the job is NOT excuted

#to know what's wrong in the xml I wrote.
# 2    - the command line is build
#      - the build log is fill
#      - the job is NOT executed

#to test the xml and the job execution and the results retrieving
# 3    - the command line is build
#      - the build log is fill
#      - the job is executed

DEBUG = 3

#to set a different debug level for a particular service
#PARTICULAR_DEBUG ={ 'serviceName' : 3 }



###################################
#
# Directories
#
##################################

#the same as defined in the apache configuration 
DOCUMENT_ROOT = '/var/www/localhost/htdocs/mobyle/dev'
  
# where to work:
# this is the absolute prefix for jobs results sub-directories
# the results will be in
# TMP_DIR+ programName + xx
# where xx is a random key

#RESULTS_PATH = "/home/bneron/Mobyle/web/results"
RESULTS_PATH = os.path.join( DOCUMENT_ROOT, 'mobyle', 'results' )

# where the xml programs description 
PROGRAMS_PATH = os.path.join( DOCUMENT_ROOT , 'mobyle', 'programs' )

# path to the user sessions directory
#USER_SESSIONS_PATH = "/home/bneron/Mobyle/web/sessions"
USER_SESSIONS_PATH = os.path.join( DOCUMENT_ROOT , 'mobyle' , 'sessions' )

# were are the binary corresponding to the services
# a list of string
# each element must be a valid path
# the element order is kept to build the final PATH ( the binary path is add before the canonical PATH )
BINARY_PATH = [ "/home/bneron/Sys/bin", "/usr/bin" , "/usr/local/bin" , "/local/gensoft/scripts", "/local/gensoft/bin" ]

#cache pour les template html 
PROGRAMS_CACHE_PATH = "/home/bneron/Mobyle/Dev/tmp"



###################################
#
# Portal
#
###################################


# the root url of mobyle 
ROOT_URL = "http://marygay.sis.pasteur.fr:82"

# this is the relative path to access to the jobs results sub-directories
# the complete url of a job will be
# ROOT_URL + TMP_URL + programName + xx
# where xx is a random key
# exemple for toppred:
# here  http://kerka.sis.pasteur.fr/Mobyle/Results/toppred/M85111376732714
# this directory should correspond to the TMP_DIR

RESULTS_URL = "mobyle/results" #utilise uniquement dans jobState

#idem for session access
SESSIONS_URL = "mobyle/sessions" 

#idem for xml descriptions programs access
PROGRAMS_URL = "mobyle/programs"


#base_project_files_url = '/MobylePortal'
#ROOT_URL + MOBYLEROOT_HTDOCS_URL
MOBYLEROOT_HTDOCS_URL = 'MobylePortal'

#base_project_cgi_url = '/cgi-bin/MobylePortal'
#ROOT_URL + MOBYLEROOT_CGI_URL
MOBYLEROOT_CGI_URL = 'cgi-bin/mobyle/dev/MobylePortal'

#the path to the golden binary 
#GOLDEN_PATH = "/local/gensoft/bin/golden" 
#je squizz le warpper gensoft ( j'ai rajoute GOLDENDATA dans l'env apache
#sinon il faudrait avoir gensoft/scripts et bin dans le path apach et donc hacker le scrit de demarrage d'apache


DATABANKS_CONFIG = {
    'embl':{
            'dataType' : 'Sequence' ,
            'bioTypes' : ['Nucleic'] ,   
            'label'    : 'EMBL Nucleotide Sequence Database',
            'command'  : ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
            },
    'genbank':{
               'dataType' : 'Sequence',
               'bioTypes' : ['Nucleic'],
               'label'    : 'Genbank NIH DNA sequence database',
               'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
               },
    'genpept':{ 
               'dataType' : 'Sequence',
               'bioTypes' : ['Protein'],   
               'label'    : 'Genbank Translated Protein-coding Sequences',
               'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
               },
    'imgt':{
            'dataType' : 'Sequence',
            'bioTypes' : ['Nucleic'],   
            'label'    : 'IMGT - ImMunoGeneTics sequence database',
            'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
            },
    'refseq':{
              'dataType' : 'Sequence',
              'bioTypes' : ['Nucleic' , 'Protein'],    
              'label'    : 'NCBI Reference Sequence (RefSeq) Database',
              'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
    },
    'uniprot':{ 
               'dataType' : 'Sequence', 
               'bioTypes' : ['Protein'], 
               'label'    : 'UniprotKB - Universal Protein Knowlege Base',
               'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
    },
    'wgs':{
           'dataType' : 'Sequence', 
           'bioTypes' : ['Nucleic'],    
           'label'    : 'Genbank - Whole Genome Shotgun',
           'command': ['/local/gensoft/bin/golden', '%(db)s:%(id)s']
    },
    'pdb':{
           'dataType':'3DStructure', 
           'bioTypes':['Protein'], 
           'label': 'Protein Data Bank', 
           'command': [ "/path/to/PDBGet.py", "%(id)s" ]
    }
    }


#PREVIEW_DATA_LIMIT =  1048576 
#####################################
#
#    Authentication
#
######################################


# to make email optional for all programs, set this to True
# default value = True
OPT_EMAIL = False

# to have a more control on the mandatory email
# it able to have the general option but
# it could be set to another value for particular service
# exemple :
# OPT_EMAIL could be set at False ( the email is mandatory )
# but set a True for some very short services.

#PARTICULAR_OPT_EMAIL = {'serviceName' : True }

#anonymous session there is 3 available values 
# no      : the anonymous sessions are not allowed
# yes     : the anonymous sessions are allowed, without any verification 
# captcha : the anonymous sessions are allowed, but with a captcha challenge ( default )
#ANONYMOUS_SESSION = "captcha"


#authenticated session there is 3 available values
# 'no'    : the authenticated session are not allowed.
# 'yes'   : the authenticated session are allowed and activated without any restriction.
# 'email' : the authenticated session are allowed but an email confirmation is needed to activate it (default).

AUTHENTICATED_SESSION = "email"
#AUTHENTICATED_SESSION = 'yes'

#####################################
#
#    misc
#
######################################

# default ='en'
#LANG = 'en'

#the time to consider that a job is long ( in sec default = 60 )
TIMEOUT = 20

REFRESH_FREQUENCY= 120

# max size for any file (2 Go )
#FILELIMIT = 2147483648

# max size for a session in bytes ( default = 50Mo = 52428800 )
SESSIONLIMIT = 52428800 
#SESSIONLIMIT = 1048576

#max size to preview the results 
#if the results size exceed this limit the results appear as a link ( default value = 1048576 = 1Mib )
#PREVIEW_DATA_LIMIT=1048576

#a list of email adresses who will recieved messages when problems occur
MAINTAINER = [ "bneron@pasteur.fr" ]

#the meail address where the user could ask some help
HELP="bneron@pasteur.fr"

#from: sender email adresse ( default = HELP )
SENDER = "mobyle-noreply@pasteur.fr"

# local mailhost
MAILHOST= "mail.pasteur.fr"

#set this True if you don't want results to be sent by email.
#This does not make email optional
#DONT_EMAIL_RESULTS = False

# max size for results by email ( in bytes default 2 Mib )
#MAXMAILSIZE = 2097152

# how long should results be available on the server ( in days default = 10)?
#RESULT_REMAIN = 10


# if you want to resolv the domain name of the user email
# and if it has a mail exchanger field
# (to avoid fake user email address)
# by default DNS_RESOLVER = False
# if DNS_RESOLVER = True dnspython must be installed

#DNS_RESOLVER = False
DNS_RESOLVER = True


####################################################
#                                                  #
#    programs needed by the sequences format       #
#          detection and conversion                # 
#                                                  #
####################################################

# the 2 sequences conveter supported by Mobyle are
# squizz and the java version of readseq
# squizz is HIGHLY recommanded

SEQCONVERTER= {
    'SQUIZZ': '/local/gensoft/bin/squizz',#je ne passe pas par les warppers
    #'SQUIZZ':  '/home/bneron/bin/squizz',
    #'READSEQ': '/usr/local/bin/jreadseq' 
    }



#####################################
#
# queuing system
#
######################################

# the allowed values are : SGE , Sys
# is plan to be supported PBS .
# mandatory
BATCH = "Sys"
#BATCH= "SGE"

#if you want to use another "queuing system" for a special service
#for all program I use SGE but for toppred which is fast I preferd to 
#launch it in Sys
PARTICULAR_BATCH = { 'toppred' : 'Sys' ,
                     'cons'    : 'Sys' ,
                      }

# the name of the default queue
#DEFAULT_Q = 'local'


# the name of a particular queue for a service
#PARTICULAR_Q = {'golden' : 'short' }


#Q_PROPERTIES={}
   



##########################################################################
#                                                                        #
#  SGE Configuration (only if you set SGE in BATCH or PARTICULAR_BATCH)  #
#                                                                        #
##########################################################################


#SGE_ROOT = "/local/gensoft/adm/sge" 
#SGE_CELL = "gensoft"


########################################
#
#       logging
#
########################################

#the directory were will stored the log files
LOGDIR = '/var/log/mobyle/dev'

# to monitored the elapsed time per job ( default = False )
ACCOUNTING = True
#SESSION_DEBUG = True

#########################################
#
# disabling services
#
#########################################


#DISABLE_ALL = False

#en url complete OUI 
DISABLED_SERVICES = [ 'http://marygay.sis.pasteur.fr:82/mobyle/programs/toppred.xml'] 


#########################################
#
# restriction services access
#
#########################################


#AUTHORIZED_SERVICES = {'dssp' : [ '157.99.60.92'] }


# serviceName : [ ip , ip mask ]

# the ip address which can use the service
# ip syntax
#
# 'toppred' : [ '125.234.60.18' , # only the machine with this ip could acces to toppred
#               '125.234.60.*'  , # all the machines in subnet could acces to toppred
#               '125.234.*.15   , # all the machine 
#             ] 
#
# if there is no entry for a service it's mean that
# every body can acces to this service



################################
#                              #
#      Services Management     #
#                              #
################################

###############################################################################
#
# Local program installation section
#
# This configuration file is used to published the xml programs description on   # 
# the Mobyle web part from the Mobyle/Local/Programs and Mobyle/Programs.        # 
# all the xml from Local/Programs are published ( PROGRAMS_PATH in Config.py )   #
# the xml from Programs are filtered following these rules                       #
#                                                                                #
# ( if this file doesn't exist all the programs from Programs were be published) #
###############################################################################
#by default ORDER=['include' , 'exclude' ]
LOCAL_DEPLOY_ORDER=[ 'exclude', 'include' ]

#LOCAL_DEPLOY_INCLUDE = [ '*' ]

#LOCAL_DEPLOY_EXCLUDE=['*']

 

          ######################
          #                    #
          #    Grid aspects    #
          #                    #
          ######################

PORTALS={'herve': {
            'url': 'http://rita.sis.pasteur.fr/cgi-bin/MobylePortal',
            'help' : 'hmenager@pasteur.fr',
            'repository': 'http://rita.sis.pasteur.fr/MobyleData/programs/',
            'programs': ['clustalw-multialign', 'sleep' ],
            'jobsBase': 'http://rita.sis.pasteur.fr/MobyleData/jobs' 
            } ,
        'adm4': {
            'url': 'http://mobyle-adm4.calcul.pasteur.fr/cgi-bin/',
            'help' : 'bneron@pasteur.fr',
            'repository': 'http://mobyle-adm4.calcul.pasteur.fr/data/programs',
            'programs': ['golden' , 'sleep' ],
            'jobsBase': 'http://mobyle-adm4.calcul.pasteur.fr/data/jobs' 
            } ,
        'rpbs': {
            'url': 'http://mobyle.rpbs.univ-paris-diderot.fr/cgi-bin',
            'help' : 'pierre.tuffery@univ-paris-diderot.fr',
            'repository': 'http://mobyle.rpbs.univ-paris-diderot.fr/programs',
            'programs': ['stride','Frog', 'XMLBlastSeq', 'PDBBlast2'],
            'jobsBase': 'http://mobyle.rpbs.univ-paris-diderot.fr/tmp'
                } ,

        }

EXPORTED_SERVICES = [ 'protpars' , 
                      'dnapars' ,
                      'toppred' , 
                      'golden', 
                      'dssp',
                      'gruppi',
                      'boxshade',
                      'sleep' , 
                     ]


