<?xml version="1.0" encoding="UTF-8"?>
<!-- This is a validating schematron file for the mobyle program				        -->
<!-- definitions, heavily inspired by existing python-based         			      -->
<!-- validators from Bertrand Néron and Nicolas Joly 							              -->
<!--                                                							              -->
<!-- Author: Hervé Ménager					             						                    -->
<!-- 'Biological Software and Databases' Group, Institut Pasteur, Paris.  		  -->
<!-- Distributed under LGPLv2 Licence. Please refer to the COPYING.LIB document.-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" >
     <pattern id="check_program">
          <rule context="program">
       	   	   <let name="commandElementsCount" value="./head/command"/>
       	   	   <let name="iscommandParametersCount" value="count(.//parameter[@iscommand='1' and not(precond) and not(ancestor::paragraph/precond)])"/>
       	   	   <let name="stdoutParametersCount" value="count(.//parameter[@isstdout='1' and not(precond) and not(ancestor::paragraph/precond)])"/>
       	   	   <let name="stderrParametersCount" value="count(.//parameter[@isstderr='1' and not(precond) and not(ancestor::paragraph/precond)])"/>
               <assert test="not(count(.//parameter[@iscommand='1'])=1 and $commandElementsCount=1)">
               A program cannot contain both a command element and an iscommand parameter
               </assert>
               <assert test="not($iscommandParametersCount=0 and $commandElementsCount=0)">
               A program has to contain one command element or one iscommand parameter:
               (<value-of select="$iscommandParametersCount"/> iscommand parameters, 
               <value-of select="$commandElementsCount"/> command elements)
               </assert>
               <assert test="$iscommandParametersCount &lt;= 1">
               	Only one parameter can be iscommand if no precond specified (current number in document: <value-of select="$iscommandParametersCount"/>)
               </assert>
               <assert test="$stdoutParametersCount &lt;= 1">
               	Only one parameter can link to standard output if no precond specified (current number in document: <value-of select="$stdoutParametersCount"/>)
               </assert>
               <assert test="$stderrParametersCount &lt;= 1">
               	Only one parameter can link to standard error if no precond specified (current number in document: <value-of select="$stderrParametersCount"/>)
               </assert>
          </rule>
          <rule context="program/head/name">
           	   <assert test="not($fileNameParameter) or concat(text(),'.xml')=$fileNameParameter">
               Inconsistency between file name (<value-of select="$fileNameParameter"/>) and name value (<value-of select="text()"/>).
          	   </assert>
					</rule>          
          <rule context="parameter">
          	   <let name="parameter" value="."/>
          	   <let name="parameterName" value="$parameter/name"/>
           	   <assert test="count($parameter//*[@undef='1']) &lt; 2">
          	   Invalid value list for parameter '<value-of select="$parameterName"/>': this parameter has multiple undefined values.
          	   </assert>
					</rule>          
          <rule context="parameter/vlist/velem | parameter/flist/felem">
          	   <let name="value" value="value/text()"/>
          	   <let name="label" value="label/text()"/>
          	   <let name="parameter" value="../.."/>
          	   <let name="parameterName" value="$parameter/name"/>
							 <assert test="not(preceding-sibling::*/value[text()=$value])" >
          	   Invalid value list for parameter '<value-of select="$parameterName"/>': duplicate value '<value-of select="$value"/>'.
							 </assert>
							 <assert test="not(preceding-sibling::*/label[text()=$label])" >
          	   Invalid value list for parameter '<value-of select="$parameterName"/>': duplicate label '<value-of select="$label"/>'.
							 </assert>
					</rule>					
          <rule context="parameter[@isout='1']">
          	   <let name="parameterName" value="name"/>
               <assert test="count(filenames) &gt; 0">
               Invalid parameter: <value-of select="$parameterName"/>: an isout parameter must include a filename
               </assert>
          </rule>
          <rule context="parameter[((not(@isout)) or (@isout='0')) and ((not(@isstdout)) or (@isstdout='0')) and ((not(@isstderr)) or (@isstderr='0'))]">
          	   <let name="parameterName" value="name"/>
               <assert test="count(filenames) = 0">
               Invalid parameter: <value-of select="$parameterName"/>: an input parameter cannot include a filename 
               </assert>
          </rule>
          <rule context="parameter/type/datatype/class">
          	   <let name="parameter" value="../../.."/>
          	   <let name="parameterName" value="$parameter/name"/>
          	   <let name="isOut" value="$parameter/@isout='1'"/>
          	   <let name="isStdout" value="$parameter/@isstdout='1'"/>
          	   <let name="isIn" value="not($isOut or $isStdout)"/>          	   
          	   <let name="isHidden" value="$parameter/@ishidden='1'"/>          	   
          	   <let name="class" value="text()"/>          	   
          	   <let name="hasDataFormats" value="count(../..//dataFormat) &gt; 0"/>          	   
          	   <assert test="not(starts-with($class,'Abstract'))">
          	   Invalid parameter datatype class for parameter '<value-of select="$parameterName"/>': no parameter datatype class can be abstract.
          	   </assert>
          	   <!-- 
          	   <assert test="not($class='Text' and not($isIn))">
          	   Invalid parameter datatype class for parameter '<value-of select="$parameterName"/>': no output parameter datatype class can be set to "Text".
          	   </assert>
          	    -->
          	   <assert test="not($class='Text' and $isHidden)">
          	   Invalid parameter datatype class for parameter '<value-of select="$parameterName"/>': no hidden parameter datatype class can be set to "Text".
          	   </assert>
          	   <assert test="$class='MultipleChoice' or count($parameter/vdef/value) &lt; 2">
          	   Invalid parameter datatype class or default value for parameter '<value-of select="$parameterName"/>': this parameter has multiple default values, yet it is not typed as a MultipleChoice.
          	   </assert>
          	   <assert test="not($class!='MultipleChoice' and $parameter/separator)">
          	   Invalid parameter datatype class or separator for parameter '<value-of select="$parameterName"/>': this parameter has a value separator specified, yet it is typed as a MultipleChoice.
          	   </assert>
          	   <assert test="not(($class='Boolean' or $class='Integer' or $class='Float' or $class='String' or $class='Choice' or $class='MultipleChoice' or $class='FileName') and ($isOut or $isStdout))">
          	   Invalid parameter datatype class for parameter '<value-of select="$parameterName"/>': no output parameter datatype class can be set to <value-of select="$class"/>.
          	   </assert>
          </rule>
          <rule context="parameter/vdef/value">
          	   <let name="value" value="text()"/>
          	   <let name="parameter" value="../.."/>
          	   <let name="parameterName" value="$parameter/name"/>
          	   <let name="class" value="$parameter/type/datatype/class"/>
          	   <let name="list" value="$parameter/vlist | $parameter/flist"/>
          	   <let name="values" value="$list//value"/>
          	   <let name="label" value="$list//label"/>
          	   <assert test="count($list)=0 or count($values[text()=$value])">
          	   Invalid default value for parameter '<value-of select="$parameterName"/>': default value <value-of select="$value"/> is not part of the possible values list.
          	   </assert>
          </rule>
     </pattern>
</schema>