########################################################################################
#                                                                                      #
#   Author: Sandrine Larroude                                                          #
#   Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.   #  
#   Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.         #
#                                                                                      #
########################################################################################

"""
Content the Mobyle Parameter types related to genomic bioloy
"""
 

from logging import getLogger
c_log = getLogger(__name__)
b_log = getLogger('Mobyle.builder')

from Mobyle.MobyleError import MobyleError , UnDefAttrError
from Mobyle.Classes.Core import AbstractTextDataType , safeMask
from Mobyle.ConfigManager import Config
_cfg = Config()



class AlignmentDataType( AbstractTextDataType ):
    


    def validate( self , param ):
        """
        @return: True if the value is valid, False otherwise
        """
        value = param.getValue()
        if param.isout():
            if value is not None : #not possible for the user to modify an isout parameter 
                return False
            else:               
                #####################################################
                #                                                   #
                #  check if the Parameter have a secure filenames   #
                #                                                   #
                #####################################################
                
                try:
                    debug = param.getDebug()
                    if debug > 1:
                        b_log.debug( "check if the Parameter have a secure filename" )
    
                    #getFilenames returns a list of unix file mask, result of a code evaluation
                    #None is returned if there is no mask for a parameter.
                    masks = param.getFilenames( ) 
                    for mask in masks :
                        if mask is None:
                            continue
                        mySafeMask = safeMask( mask )
                        if debug > 1:
                            b_log.debug( "filename= %s    safeMask = %s" % (mask, mySafeMask))
                        if  not mySafeMask or mySafeMask != mask :
                            raise MobyleError , "have an unsecure filenames value before safeMask: %s , after safeMask: %s" % (mask, mySafeMask)
                        elif debug > 1:
                            b_log.debug( "filename = %s ...........OK" % mask )
                                               
                except UnDefAttrError :
                    b_log.debug("no filenames")

        else:
            if value is None:
                return True
            else:
                return True            
             