########################################################################################
#                                                                                      #
#   Author: Bertrand Neron,                                                            #
#   Organization:'Biological Software and Databases' Group, Institut Pasteur, Paris.   #  
#   Distributed under GPLv2 Licence. Please refer to the COPYING.LIB document.         #
#                                                                                      #
########################################################################################

"""
Content the Mobyle Parameter types related to the genomic bioloy
"""
 

from logging import getLogger
c_log = getLogger(__name__)
b_log = getLogger('Mobyle.builder')

from Mobyle.MobyleError import MobyleError , UnDefAttrError 
from Mobyle.Classes.Core import AbstractTextDataType , safeMask
from Mobyle.ConfigManager import Config
_cfg = Config()


class SequenceDataType( AbstractTextDataType ):
    
     
 
    def validate( self , param ):
        """
        """
        value = param.getValue()

        if param.isout():
            if value is not None : #un parametre isout ne doit pas etre modifier par l'utilisateur 
                return False
            else:
                #####################################################
                #                                                   #
                #  check if the Parameter have a secure filenames   #
                #                                                   #
                #####################################################
                try:
                    debug = param.getDebug()
                    if debug > 1:
                        b_log.debug( "check if the Parameter have a secure filename" )
    
                    #getFilenames return list of strings representing a unix file mask which is the result of a code evaluation
                    #getFilenames return None if there is no mask for a parameter.
                    filenames = param.getFilenames( ) 
                    for filename in filenames :
                        if filename is None:
                            continue
                        mask = safeMask( filename )
                        if debug > 1:
                            b_log.debug( "filename= %s    safeMask = %s"%(filename, mask))
                        if  not mask or mask != filename :
                            raise MobyleError , "have an unsecure filenames value before safeMask: %s , after safeMask: %s"%( filename , mask )
                        else:
                            if debug > 1:
                                b_log.debug( "filename = %s ...........OK" % filename )
                                               
                except UnDefAttrError :
                    b_log.debug("no filenames")
        else:#the param is an inFile
            if value is None:
                return True
            else:
                return True
