"""
This module is used as template to build a converter module
"""
import os
import re
from subprocess import Popen , PIPE
from logging import getLogger
_log = getLogger( __name__ )


from Mobyle.MobyleError import MobyleError , UnSupportedFormatError
from Mobyle.Converter.DataConverter import DataConverter

class iANTConverter( DataConverter ):
    
    def __init__(self ):
        super( iANTConverter , self ).__init__( '/www-mobyle/programs/annotation/bin/int/iANT.aa_dna.FastaEntryDBConverter.pl' )
        self.program_name = 'iANT.aa_dna.FastaEntryDBConverter.pl'
        
    def detect( self, dataFileName ):
        """
        detect the format of the data.
        @param dataFileName: the filename of the data which the format must be detected
        @type dataFileName: string
        @return: the format of this data and the number of entry. 
               if the format cannot be detected, return None
               if the number of entry cannot be detected, return None
        @rtype: ( string format , int number of entry ) 
        """
        if self.path is None :
            _log.critical( "iANTConverter path is not configured" )
            raise MobyleError , 'iANTConverter is required to handle data iANTReport but not configured'
        else:
            try:
                iANTConverter_pipe = Popen( [ self.path , "--get_mobyle_dataformat" , dataFileName ] ,
                                     shell = False ,
                                     stdout = PIPE ,
                                     stdin = None ,
                                     stderr = None
                                     )
            except OSError , err :
                msg = "iANTConverter exit abnormally: " + err
                _log.critical( msg )
                raise MobyleError, msg
            iANTConverter_pipe.wait()
            if iANTConverter_pipe.returncode != 0:
                msg = ''.join( iANTConverter_pipe.stdout.readlines() )
                raise MobyleError , msg

            for line in iANTConverter_pipe.stdout :
                match = re.search( "(.+),(\d+)$" ,  line)
                if match :
                    format = match.group(1)
                    seq_nb = int( match.group(2))

        if match and format != "UNKNOWN":
            return ( format , seq_nb )
        else:
            return ( None  , None )
    
    def detectedFormat(self):
        """
        @return: the list of detectables formats.
        @rtype: list of stings
        """
        return ['iANTEntryDBReport','iANTEntryReport','FASTA']
    
    
    def convert( self, dataFileName , outputFormat , inputFormat = None):
        """
        convert a data in the format outputFormat
        @param dataFileName: the filename of the data to convert
        @type dataFileName: string
        @param outputFormat: the format in which the data must be convert in.
        @type outputFormat: string
        @param inputFormat: the format of the data 
        @type inputFormat: string
        @return: the filename of the converted data.
        @rtype: string
        @raise UnsupportedFormatError: if the outputFormat is not supported, or if the data is in unsupported format.
        """
        outFileName = os.path.splitext( dataFileName )[0] + self.suffixe( outputFormat )
        cmde = [ self.path , outputFormat ]
        if  inputFormat:
            if inputFormat == "FASTA":
                cmde += [ "-sequence" , inputFormat ,
                     dataFileName
                     ]
            else:
                cmde += [ "-xml" , inputFormat ,
                     dataFileName
                     ]
        else:
            cmde.append( dataFileName )
        try:
            outFile = open( outFileName , 'w' )
        except IOError ,err :
            _log.error( "can't write outFile:" + str( err ) )
            raise MobyleError , "Sequence Convertion Error: "+ str( err )
        try:
            iANTConverter_pipe = Popen( cmde ,
                                 shell  = False ,
                                 stdout = outFile ,
                                 stdin  = None ,
                                 stderr = PIPE
                                 )
        except OSError, err:
            raise MobyleError , "iANTConverter exit abnormally: "+ str( err )

        iANTConverter_pipe.wait()
        err = ''.join( iANTConverter_pipe.stderr.readlines() )
        if iANTConverter_pipe.returncode != 0:
            msg = err
            _log.error( msg )
            raise MobyleError , msg
        else:
            outFile.close()
            return outFileName

    
    def convertedFormat(self):
        """
        @return: the list of allowed conversion ( inputFormat , outputFormat ) 
        @rtype: [ ( string inputFormat, string outputFormat )  , ... ]
        """
        return [ ('iANTEntryDBReport','FASTA'),('iANTEntryReport','FASTA') ,('FASTA','iANTEntryDBReport'),('FASTA','iANTEntryReport')]


