#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
import os

def process(self):
    self.template_file = 'portal.html'
    if self.session:
        self.response['authenticated'] = self.session.isAuthenticated()
        self.response['activated'] = self.session.isActivated()
        actkey = self.request.getfirst('actkey')
        if actkey:
            self.response['actkey'] = actkey
    else:
        self.response['sessionId'] = None
        self.response['authenticated'] = False
        self.response['activated'] = False
    self.response['anonymousSession'] = (self.cfg.anonymousSession()!='no')
    self.response['authenticatedSession'] = (self.cfg.authenticatedSession()!='no')
    self.response['sessionLimit']='%.2f'%(float(self.cfg.sessionlimit())/1000)
    self.response['refresh_frequency']=self.cfg.refreshFrequency()
    #OPENID
    self.response['openid']=(self.cfg.openid()!=False)

    self.response['messages'] = []
    annFileName = os.path.normpath(os.path.join( self.cfg.portal_path(),"html/announcement.txt"))
    self.cssDir = '/'+self.cfg.portal_url(True)+"/css/"
    self.jsDir = '/'+self.cfg.portal_url(True)+"/js/"
    self.htDir = '/'+self.cfg.portal_url(True)+"/"
    if self.cfg.welcome_config().get('format')=='atom':
        self.welcome_url =  "feed_view.py?url="+self.cfg.welcome_config().get('url')+"&amp;fmt="+self.cfg.welcome_config().get('format')
    elif self.cfg.welcome_config().get('format')=='html':
        self.welcome_url = self.cfg.welcome_config().get('url')
    if os.path.isfile(annFileName):
        templateCacheFile = open (annFileName,'r')
        self.response['announcement'] = templateCacheFile.read()
        templateCacheFile.close()

if __name__ == "__main__":
    mb_cgi.TALCGI(processFunction=process,useSession=True)
