#! /usr/bin/env python
#############################################################
#                                                           #
#   Author: Herve Menager                                   #
#   Organization:'Biological Software and Databases' Group, #
#                Institut Pasteur, Paris.                   #
#   Distributed under GPLv2 Licence. Please refer to the    #
#   COPYING.LIB document.                                   #
#                                                           #
#############################################################
import mb_cgi
from Mobyle.DataInputsIndex import DataInputsIndex
from  Mobyle.Classes.DataType import DataTypeFactory

def process( self ):
    bc = self.cfg.getDatabanksConfig()
    pdi = DataInputsIndex("program")
    vdi = DataInputsIndex("viewer")
    datatypes = {}
    df = DataTypeFactory()
    dataInputsList = pdi.getList().values() + vdi.getList().values()
    for parameter in dataInputsList:
        if not(datatypes.has_key(parameter.get('dataTypeClass'))):
            datatypes[parameter.get('dataTypeClass')]={}
            if parameter.get('dataTypeSuperClass'):
                dt = df.newDataType(parameter.get('dataTypeSuperClass'),parameter.get('dataTypeClass'))
            else:
                dt = df.newDataType(parameter.get('dataTypeClass'))
            datatypes[parameter.get('dataTypeClass')]['ancestorTypes']=dt.ancestors
    self.jsonMap = {'portal_name': self.cfg.portal_name(),
                    'conversions':self.cfg.data_conversions(),
                    'banks': bc,
                    'program_inputs': pdi.getList(),
                    'viewer_inputs': vdi.getList(),
                    'datatypes':datatypes,
                    'htbase':'/'+self.cfg.portal_url(True)+"/"}

if __name__ == "__main__":
    mb_cgi.JSONCGI(processFunction=process,mime_type="application/javascript",wrapper="var portalProperties = %s;")