#! /usr/bin/python

import os
import sys
import imp
sys.path.append( '/home/bneron/Mobyle/trunk/mobyle/Src')

import Mobyle.ConfigManager
import logging 
_log = logging.getLogger( 'Mobyle.LSF' )

import Mobyle.JobState
import Mobyle.Utils
from Mobyle.Execution.ExecutionSystem import ExecutionSystem 

from Mobyle.MobyleError import MobyleError


class DRMAA( ExecutionSystem ):
    
    
    def __init__( self , drmaa_config ):
        self._cfg = Mobyle.ConfigManager.Config()
        self.execution_config = drmaa_config
        self.execution_config_alias = self._cfg.getAliasFromConfig( self.execution_config )
        #indispensable pour instancier une Session
        os.environ[ 'LSF_SERVERDIR' ] = '/home/bneron/Sys/share/lsf/7.0/linux2.6-glibc2.3-x86_64/etc'
        os.environ[ 'LSF_ENVDIR' ] = '/home/bneron/Sys/share/lsf/conf'
        os.environ [ 'DRMAA_LIBRARY_PATH' ] = '/home/bneron/Sys/lib/libdrmaa.so'
        try:
            fp , pathname , description =  imp.find_module( "drmaa" )
        except Exception , err :
            print >> sys.stderr ,"erreur d'import drmaaa" , err
            raise err
        self.drmaa = imp.load_module( "drmaa" , fp , pathname , description )
        
    def _drmaaStatus2mobyleStatus( self , drmaaStatus ):
        if drmaaStatus == self.drmaa.JobState.RUNNING:
            return Mobyle.Status.Status( 3 ) #running
        elif drmaaStatus == self.drmaa.JobState.UNDETERMINED:
            return Mobyle.Status.Status( -1 ) #unknown
        elif drmaaStatus == self.drmaa.JobState.QUEUED_ACTIVE:
            return Mobyle.Status.Status( 2 ) #pending
        elif drmaaStatus == self.drmaa.JobState.DONE:
            return Mobyle.Status.Status( 4 ) #finished
        elif drmaaStatus == self.drmaa.JobState.FAILED:
            return Mobyle.Status.Status( 5 ) # error
        elif drmaaStatus == self.drmaa.JobState.SYSTEM_ON_HOLD:
            return Mobyle.Status.Status( 7 ) # hold
        elif drmaaStatus == self.drmaa.JobState.USER_ON_HOLD:
            return Mobyle.Status.Status( 7 ) # hold
        elif drmaaStatus == self.drmaa.JobState.USER_SYSTEM_ON_HOLD:
            return Mobyle.Status.Status( 7 ) # hold
        elif drmaaStatus == self.drmaa.JobState.SYSTEM_SUSPENDED:
            return Mobyle.Status.Status( 7 ) # hold
        elif drmaaStatus == self.drmaa.JobState.USER_SUSPENDED:
            return Mobyle.Status.Status( 7 ) # hold
        elif drmaaStatus == self.drmaa.JobState.USER_SYSTEM_SUSPENDED:
            return Mobyle.Status.Status( 7 ) # hold
        else:
            return Mobyle.Status.Status( -1 )
           
           
    def _run(self ,commandLine , dirPath , serviceName , jobKey , jobState , queue , xmlEnv , ):
        if (os.getcwd() != os.path.abspath(dirPath) ):
            msg = "the process is not in the working directory"
            
            self._logError( admMsg = msg , 
                            userMsg = "Mobyle internal server error" , 
                            logMsg = msg )
            raise MobyleError , msg
        
        else:
            fout = open( serviceName + ".out" , 'w' )
            ferr = open( serviceName + ".err" , 'w' )
            try:
                drmaaSession= self.drmaa.Session('marygay.sis.pasteur.fr')
                print "drmsInfo = ", drmaaSession.drmsInfo
                print "drmaImplementation = ", drmaaSession.drmaaImplementation
                jt = drmaaSession.createJobTemplate( ) 
                jt.workingDirectory = os.getcwd() 
                jt.outputPath = ":"+os.path.join( dirPath , fout.name )
                jt.errorPath = ":"+os.path.join( dirPath , ferr.name )
                jt.joinFiles = False
                jt.remoteCommand = '/home/bneron/Sys/bin/test_drm'
                try:
                    time2sleep =  sys.argv[1] 
                except:
                    time2sleep = '5'
                jt.args=[ time2sleep ]
                jt.nativeSpecification = "-q mobyle "
                drmJobid = drmaaSession.runJob( jt )
            except self.drmaa.errors , err :
                _log.error( "cannot exit from drmaa properly try to deleting JobTemplate: " + str( err ) )
                try:
                    drmaaSession.deleteJobTemplate( jt )
                    drmaaSession.exit()
                except Exception , err :
                    _log.error( "cannot exit from drmaa properly : " + str( err ) )
                    pass
                msg= "System execution failed: " +str( err ) 
                self._logError( admMsg = msg ,
                                userMsg = "Mobyle internal server error" ,
                                logMsg = None )
                
                _log.critical( "%s/%s : %s" %( serviceName ,
                                                   jobKey ,
                                                   msg
                                                   )
                                 )
    
                raise MobyleError , msg 
            except  Exception , err :
                _log.debug( "an error occured in drmaa.run method : %s" %err )
                raise MobyleError( "Internal Server Error")
            
            adm = Mobyle.Admin.Admin( dirPath )
            adm.setExecutionAlias( 'DRMAA_test' ) 
            adm.setNumber( drmJobid ) 
            adm.commit()
            linkName = ( "%s/%s.%s" %( self._cfg.admindir() ,
                                       serviceName ,
                                       jobKey
                                    )
                         )
            
            try:
                os.symlink(
                    os.path.join( dirPath , '.admin') ,
                    linkName
                    )
            except OSError , err:
                try:
                    drmaaSession.deleteJobTemplate( jt )
                    drmaaSession.exit()
                except Exception , err :
                    _log.error( "cannot exit from drmaa properly : " + str( err ) )
                    
                msg = "can't create symbolic link %s in ADMINDIR: %s" %( linkName , err )

                self._logError( admMsg = msg ,
                                userMsg = "Mobyle internal server error" ,
                                logMsg = None )
                
                _log.critical( "%s/%s : %s" %( serviceName ,
                                               jobKey ,
                                               msg
                                            )
                                 )

                raise MobyleError , msg
                        
            #JobInfo =( jobId , hasExited , hasSignal , terminatedSignal, hasCoreDump, wasAborted, exitStatus, resourceUsage)
            #            0          1          2              3               4            5           6           7
            jobInfos = drmaaSession.wait( drmJobid , self.drmaa.Session.TIMEOUT_WAIT_FOREVER )
            
            try:
                os.unlink( linkName )
            except OSError , err:
                try:
                    drmaaSession.deleteJobTemplate( jt )
                    drmaaSession.exit()
                except Exception , err :
                    _log.error( "cannot exit from drmaa properly : " + str( err ) )
                    
                msg = "cannot remove symbolic link %s in ADMINDIR: %s" %( linkName , err )

                self._logError( admMsg = msg ,
                                userMsg = "Mobyle internal server error" ,
                                logMsg = None )
                
                _log.critical( "%s/%s : %s" %( serviceName ,
                                               jobKey ,
                                               msg
                                            )
                                 )

                raise MobyleError , msg
            fout.close()
            ferr.close()
            
            adm = Mobyle.Admin.Admin( dirPath )
            oldStatus = adm.getStatus()
            
            if oldStatus.isEnded():
                status= oldStatus
            else:
                if jobInfos[ 5 ] :#wasAborted
                    status = Mobyle.Status.Status( code = 6 , message = "Your job has been cancelled" ) #killed
                else:
                    if jobInfos[ 1 ]:#hasExited
                        if jobInfos[ 6 ] == 0:#exitStatus
                            status = Mobyle.Status.Status( code = 4 ) #finished
                        else:
                            status = Mobyle.Status.Status( code = 4 , message = "Your job finished with an unusual status code ( %d ), check your results carefully." % jobInfos[ 6 ] )
                    else:
                        status = Mobyle.Status.Status( code = 6 , message = "Your job execution failed ( %d )" %jobInfos[ 6 ] ) 

            try:
                drmaaSession.deleteJobTemplate( jt )
                drmaaSession.exit()
            except :
                _log.error( "cannot exit from drmaa properly" )
            
            return status

        
    
if __name__ == '__main__':
    import Mobyle.Job
    service = Mobyle.Utils.makeService( 'http://marygay.sis.pasteur.fr:82/data/programs/lsf_drmaa.xml' )
    configM = Mobyle.ConfigManager.Config()
    job = Mobyle.Job.Job( service , configM )
    dirPath = job.getDir()
    commandLine = '/home/bneron/Sys/bin/test_drm'
    serviceName = service.getName()
    jobKey  = job.getKey()
    jobState = None
    queue = 'mobyle'
    xmlEnv= {}
    drmaa_config = configM.getExecutionConfigFromAlias( 'LSF' )
    print "Content-type: text/plain\n\n"
    drm = DRMAA( drmaa_config )
    ret_val = drm._run( commandLine , dirPath , serviceName , jobKey , jobState , queue , xmlEnv )
    print ret_val  