<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- 
	annotate.xsl stylesheet
	Authors: Herv� M�nager
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" xmlns:xhtml="http://www.w3.org/1999/xhtml">

	<xsl:include href="ident.xsl" />

	<!-- processing parameters to annotate them with necessary classes and transform nesting labels into fieldsets --> 
	<xsl:template match="xhtml:label[not(xhtml:label) and (not(xhtml:input[@type='radio']))]">
		<xsl:variable name="param-name" select="current()//xhtml:*/@name" />
		<xsl:element name="label" use-attribute-sets="param">
			<xsl:apply-templates select="@*" />
			<xsl:apply-templates select="text()" />
			<xsl:apply-templates select="//parameter[(name/text()=$param-name)]/type" mode="label"/>
			<xsl:apply-templates select="//parameter[(name/text()=$param-name)]/comment" mode="ajaxLink"/>			
			<xsl:apply-templates select="//parameter[(name/text()=$param-name)]/example" mode="ajaxLink"/>			
			<xsl:apply-templates select="*" />
			<xsl:apply-templates select="//parameter[(name/text()=$param-name)]/comment" mode="ajaxTarget"/>
			<xsl:apply-templates select="//parameter[(name/text()=$param-name)]/example" mode="ajaxTarget"/>
		</xsl:element>
	</xsl:template>	

	<xsl:template match="xhtml:label[xhtml:label]">
		<xsl:element name="fieldset" use-attribute-sets="param">
			<xsl:apply-templates select="@*" />
			<legend>
				<xsl:value-of select="text()"/>
				<xsl:apply-templates select="//parameter[(name/text()=current()//xhtml:*/@name)]/comment" mode="ajaxLink"/>			
			</legend>
			<xsl:apply-templates select="//parameter[(name/text()=current()//xhtml:*/@name)]/comment" mode="ajaxTarget" />			
			<xsl:apply-templates select="*" />
		</xsl:element>
	</xsl:template>

	<xsl:template match="xhtml:fieldset[@data-paragraphname]">
		<xsl:element name="fieldset">
			<xsl:apply-templates select="@*" />
			<xsl:apply-templates select="xhtml:legend" />
			<xsl:apply-templates select="//paragraph[(name/text()=current()/@data-paragraphname)]/comment" mode="ajaxTarget"/>
			<xsl:apply-templates select="//paragraph[(name/text()=current()/@data-paragraphname)]/example" mode="ajaxTarget"/>
			<xsl:apply-templates select="*[local-name()!='legend']" />
		</xsl:element>
	</xsl:template>

	<xsl:template match="xhtml:fieldset[@data-parametername]">
		<xsl:element name="fieldset" use-attribute-sets="param">
			<xsl:apply-templates select="@*" />
			<xsl:apply-templates select="xhtml:legend" />
			<xsl:apply-templates select="//parameter[(name/text()=current()/@data-parametername)]/comment" mode="ajaxTarget"/>			
			<xsl:apply-templates select="//parameter[(name/text()=current()/@data-parametername)]/example" mode="ajaxTarget"/>			
			<xsl:apply-templates select="*[local-name()!='legend']" />
		</xsl:element>
	</xsl:template>	

	<xsl:template match="xhtml:fieldset/xhtml:legend">
		<legend>
			<xsl:apply-templates select="@*|node()|text()" />
			<xsl:apply-templates select="//parameter[(name/text()=current()/../@data-parametername)]/comment" mode="ajaxLink"/>			
			<xsl:apply-templates select="//parameter[(name/text()=current()/../@data-parametername)]/example" mode="ajaxLink"/>			
		</legend>		
	</xsl:template>		

	<xsl:template match="comment" mode="ajaxLink">
		<a href="#{generate-id(..)}::comment" class="blindLink commentToggle" title="click to expand/collapse contextual help">?</a>		
	</xsl:template>

	<xsl:template match="example" mode="ajaxLink">
		<a href="#{generate-id(..)}::example" class="exampleLink" title="click to prefill with an example">[use example data]</a>		
		<xsl:if test="not(../comment)">
			<a href="#{generate-id(..)}::comment" class="blindLink commentToggle" title="click to expand/collapse contextual help">?</a>		
		</xsl:if>
	</xsl:template>	

	<xsl:template match="comment" mode="ajaxTarget">
		<xsl:choose>
			<xsl:when test="text">
				<div id="{generate-id(..)}::comment" class="commentText" style="display:none" mode="ajaxTarget">
					<xsl:apply-templates select="text" mode="ajaxTarget"/>
					<xsl:apply-templates select="../example" mode="exampleInclude"/>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div id="{generate-id(..)}::comment" class="commentText" style="display:none" mode="ajaxTarget">
					<xsl:copy-of select="xhtml:*|text()" />	  	
					<xsl:apply-templates select="../example" mode="exampleInclude"/>
				</div>
			</xsl:otherwise>			
		</xsl:choose>
	</xsl:template>

	<xsl:template match="comment/text" mode="ajaxTarget">
    	<div><xsl:apply-templates select="text()" /></div>
    </xsl:template>
	
	<xsl:template match="example" mode="ajaxTarget">
		<div class="example" id="{generate-id(..)}::example" data-forparameter="{../name/text()}" style="display:none">
			<pre><xsl:value-of select="."/></pre>
		</div>
		<xsl:if test="not(../comment)">
			<div id="{generate-id(..)}::comment" class="commentText" style="display:none" mode="ajaxTarget">
				<xsl:apply-templates select="../example" mode="exampleInclude"/>
			</div>			
		</xsl:if>
	</xsl:template>	

	<xsl:template match="example" mode="exampleInclude">
		<div class="example" id="{generate-id(..)}::example" data-forparameter="{../name/text()}">Example data <i>(click on <a>[use example data]</a> to load)</i>:
			<pre><xsl:value-of select="."/></pre>
		</div>
	</xsl:template> 
	
</xsl:stylesheet>
