<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" xmlns:xhtml="http://www.w3.org/1999/xhtml">
  
  <xsl:output method="html" indent="yes" />	

  <xsl:include href="ident.xsl" />

  <xsl:param name="jobPID" ></xsl:param>  

  <xsl:param name="previewDataLimit" >99999999999999999999999999</xsl:param>  
  
  <xsl:variable name="job" select="/"/>
  
  <xsl:variable name="jobId" select="$job/jobState/id"/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$jobPID!=''">
        <xsl:apply-templates select="/jobState/program|/jobState/workflow" />              
      </xsl:when>
      <xsl:otherwise>
        <html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
          <!-- TODO update all CSS links -->
          <head>
          <!-- here we compute the path to the css stylesheets dir, based on the href pseudo-attribute of the XSL processing instruction -->
          <xsl:variable name="xslUri" select="translate(substring-before(substring-after(processing-instruction('xml-stylesheet'), 'href='), ' '),'&quot;','')" />
          <xsl:variable name="cssBase" select="concat(substring-before($xslUri, '/xsl'),'/css/')" />
          <title>Mobyle job report for <xsl:value-of select="$jobId"/></title>
          <style type="text/css">
            @import "<xsl:value-of select='$cssBase' />mobyle.css"; 
            @import "mobyle.css"; 
            .minimizable.minimized  > legend{
                background-image: none;
                display:inherit;
            }

            .minimizable.minimized > *{
                display:block;
            }
          </style>
          </head>
          <body>
            <xsl:apply-templates select="/jobState/program|/jobState/workflow" />              
          </body>
        </html>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>    
    

  <xsl:template match="/jobState/program|/jobState/workflow">    
    <div class="job"
      data-jobid="{$jobId}"
      data-jobpid="{$jobPID}"
      data-pid="{$jobPID}"
      data-servicename="{$job/jobState/name/text()}" 
      data-servicelocalname="{/jobState/*/head/name/text()}" 
      data-jobdate="{$job/jobState/date/text()}" 
      data-jobstatus="{$job/jobState/status/value/text()}"
      data-jobmessage="{$job/jobState/status/message/text()}">
        <fieldset class="job_controls">
          <legend class="jobstatus {$job/jobState/status/value}" title="status: {$job/jobState/status/value}">
            <xsl:value-of select="$jobId" />
          </legend>
          <xsl:apply-templates select="$job/jobState/status/message" />
          <xsl:if test="$jobPID!=''"><!-- only display if jobPID available, i.e., we are working within the portal -->
            <xsl:variable name="servicePID">
              <xsl:variable name="a1" select="substring-before($jobPID,'.')" />
              <xsl:variable name="a2" select="substring-after($jobPID,'.')" />
              <xsl:variable name="b1" select="substring-before($a2,'.')" />
              <xsl:variable name="b2" select="substring-after($a2,'.')" />
              <xsl:if test="$b2!=''">
                <xsl:value-of select="$a1"/>.<xsl:value-of select="$b1"/>
              </xsl:if>
              <xsl:if test="$b2=''">
                <xsl:value-of select="$a1"/>
              </xsl:if>
            </xsl:variable>  
            <xsl:if test="not($job/jobState/workflowID)">
              <xsl:if test="$job/jobState/status/value!='finished' and $job/jobState/status/value!='error' and $job/jobState/status/value!='killed'">
                <a href="#"><button type="button" class="update_status">update</button></a>          
              </xsl:if>
              <a href="#user::help::{$jobId}" class="modalLink"><button type="button">get help</button></a>               
              <a href="#forms::{$servicePID}" class="link"><button type="button">back to form</button></a>                
              <a href="#user::jobremove::{$jobPID}" class="modalLink"><button type="button">remove job</button></a>                
            </xsl:if>
            <xsl:if test="$job/jobState/status/value='finished' or $job/jobState/status/value='error' or $job/jobState/status/value='killed'">
              <a href="{$jobId}/{/jobState/*/head/name/text()}_{substring-after($jobId,concat(/jobState/*/head/name/text(),'/'))}.zip">
                <button type="button">download</button>
              </a>
            </xsl:if>
          </xsl:if>
        </fieldset>
      <xsl:if test="$job/jobState/data/output">
        <fieldset class="job_results">
          <legend>results</legend>
          <xsl:apply-templates select="/jobState/*/head/interface[@type='job_output']/*"/> 
        </fieldset>
      </xsl:if>
      <fieldset class="job_inputs">
        <legend>parameters</legend>
        <xsl:apply-templates select="/jobState/*/head/interface[@type='job_input']/*"/>
      </fieldset>
      <xsl:if test="$job/jobState/commandLine or $job/jobState/paramFiles/file">
        <fieldset class="job_details minimizable minimized">
          <legend>job execution</legend>
          <div>
          <xsl:apply-templates select="$job/jobState/commandLine"/>          
          <xsl:apply-templates select="$job/jobState/paramFiles/file"/>
          </div>
        </fieldset>
      </xsl:if>
      <xsl:if test="$job/jobState/jobLink">
        <xsl:apply-templates select="/jobState/workflow/flow"/>     
      </xsl:if>   
    </div>
  </xsl:template>

  <xsl:template match="flow">
    <xsl:if test="$jobPID!=''">
      <fieldset class="job_details minimizable">
        <legend>workflow details</legend>
        <div>
          <center>
          <object class="workflow_graph" data="workflow_job_layout.py?id={$jobPID}">
          </object>
          <map name="workflow_map::{$jobPID}">
            <area shape="poly" coords="216,-30 216,-80 592,-80 592,-30 216,-30" href="#jobs::{$jobPID}::clustalw-multialign.A08919013086081" />
            <area shape="rect" coords="0, 0, 1000, 1000" href="#jobs::{$jobPID}::clustalw-multialign.A08919013086081" />
          </map>          
        </center>
  <!--
        <div id="ms-jobs::{$jobPID}">
          <ul class="handlesList">
          </ul>
          <div class="panelsList">
          </div>
        </div>
  -->
        </div>
      </fieldset>
    </xsl:if>
  </xsl:template>

  <xsl:template match="jobState/status/message">
    <div class="info" style="white-space:pre-wrap;">
      <xsl:value-of select="text()" />
    </div>    
  </xsl:template>

  <xsl:template match="xhtml:*[@data-paragraphname]">
    <!-- do not display a paragraph unless there are data to be displayed -->
    <xsl:if test="$job/jobState/data//*[name/text()=current()//@data-parametername]">
      <xsl:element name="{local-name(.)}">
        <xsl:apply-templates select="@*|node()" />
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xsl:template match="xhtml:*[@data-parametername]">
    <!-- do not display a parameter unless there are data to be displayed -->
    <xsl:variable name='parametername' select="@data-parametername"/>
    <xsl:if test="$job/jobState/data/*[parameter/name=$parametername]">
      <xsl:element name="{local-name(.)}" use-attribute-sets="param">
        <!-- override data-format for dynamically-specified version -->
        <xsl:attribute name="data-inputmodes">results</xsl:attribute>
        <xsl:attribute name="data-format">
          <xsl:apply-templates select="//parameter[name/text()=$parametername]/type/dataFormat" mode="dataFormats" />
        </xsl:attribute>        
        <xsl:attribute name="title">
          <xsl:value-of select="//parameter[name/text()=$parametername]/type/biotype"/>
          <xsl:value-of select="//parameter[name/text()=$parametername]/type/datatype/class"/>
          <xsl:if test="//parameter[name/text()=$parametername]/type/dataFormat">
          - format: <xsl:apply-templates select="//parameter[name/text()=$parametername]/type/dataFormat" mode="dataFormats" />
          </xsl:if>
        </xsl:attribute>
        <xsl:apply-templates select="@*|node()|text()" />
        <!-- display "file" data or "simple values" stored in the XML-->
        <xsl:apply-templates select="$job/jobState/data/*[parameter/name=$parametername]/file" mode="dataProcessing"/>
        <xsl:apply-templates select="$job/jobState/data/*[parameter/name=$parametername]/value" mode="dataProcessing"/>
        </xsl:element>
    </xsl:if>
  </xsl:template>  

  <xsl:template match="dataFormat/text()" mode="dataFormats">
    <xsl:copy-of select="normalize-space(.)"/>
  </xsl:template>

  <xsl:template match="dataFormat/ref" mode="dataFormats">
    <xsl:variable name="ref"><xsl:value-of select="@param"/></xsl:variable>
    <xsl:choose>
      <xsl:when test="$job/jobState/data/*[parameter/name=$ref]/value">
        <xsl:value-of select="normalize-space($job/jobState/data/*[parameter/name=$ref]/value)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="normalize-space(//parameter[name/text()=$ref]/vdef/value)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="dataFormat/test" mode="dataFormats">
    <xsl:variable name="ref"><xsl:value-of select="@param"/></xsl:variable>
    <xsl:choose>
      <xsl:when test="$job/jobState/data/*[parameter/name=$ref]/value">
        <xsl:variable name="value" select="$job/jobState/data/*[parameter/name=$ref]/value"/>
        <xsl:choose>
          <xsl:when test="@eq and @eq=$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@ne and @ne!=$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@lt and @lt&lt;$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@le and @le&lt;=$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@gt and @gt&gt;$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@ge and @ge&gt;=$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="value" select="//parameter[name/text()=$ref]/vdef/value"/>
        <xsl:choose>
          <xsl:when test="@eq and @eq=$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@ne and @ne!=$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@lt and @lt&lt;$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@le and @le&lt;=$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@gt and @gt&gt;$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
          <xsl:when test="@ge and @ge&gt;=$value"><xsl:apply-templates select="child::node()" mode="dataFormats"/></xsl:when>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="value" mode="dataProcessing">
    <xsl:text> </xsl:text><span class="parameter_value"><xsl:value-of select="text()"/></span>
  </xsl:template>	

  <xsl:template match="file" mode="dataProcessing">
    <xsl:variable name='resultId' select="concat($jobId,'/',text())"/>
    <fieldset>
      <xsl:attribute name="class">
        minimizable <xsl:if test="name(..)='input'">minimized</xsl:if>
      </xsl:attribute>
      <legend>
        <xsl:value-of select="text()"/>
        <a target="_blank" class="saveFileLink" title="save this file" alt="save this file" href="{$resultId}?save"><xsl:text> </xsl:text></a>
      </legend>
      <span>      
        <span data-filename="{text()}" data-src="{$resultId}">

        <xsl:choose>
          <xsl:when test="//parameter[not(ancestor-or-self::jobState) and name/text()=current()/../parameter/name]/interface">
            <xsl:apply-templates select="//parameter[not(ancestor-or-self::jobState) and name/text()=current()/../parameter/name]/interface" />
          </xsl:when>     
          <xsl:when test="@size&lt;=$previewDataLimit">
            <object data="{$resultId}">
              This file cannot be displayed in your browser. Click on the save button to download it.
            </object>             
          </xsl:when>
          <xsl:otherwise>
            <p class="commentText">
              The file is too big to be safely displayed here (<xsl:value-of select="round(number(@size) div 1024)"/> KiB).
              Click here to display this result in a separate window.
            </p>
          </xsl:otherwise>
        </xsl:choose>
      </span>
      </span>
    </fieldset>
  </xsl:template>

  <xsl:template match="commandLine">
    <fieldset>
      <legend>Command line</legend>
      <div><xsl:value-of select="text()" /></div>
    </fieldset>
  </xsl:template>
  
  <xsl:template match="commandLine">
    <fieldset>
      <legend>Command line</legend>
      <div><xsl:value-of select="text()" /></div>
    </fieldset>
  </xsl:template>
  
  <xsl:template match="paramFiles/file">
    <fieldset>
      <legend>Parameters file:</legend>
      <a href="{$jobId}/{text()}" target="_blank"><xsl:value-of select="text()"/></a>
    </fieldset>
  </xsl:template>
  
</xsl:stylesheet>