<?xml version="1.0" encoding="utf-8"?>
<!-- 
	job_graph.xsl stylesheet
	Authors: Hervé Ménager
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" 
	xmlns:xhtml="http://www.w3.org/1999/xhtml" 
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:xlink="http://www.w3.org/1999/xlink">

	<xsl:include href="ident.xsl" />

	<xsl:param name="jobPID" />	

	<xsl:template match="processing-instruction()">
	</xsl:template>
	
	<xsl:template match="/jobState">
		<xsl:apply-templates select="workflow/head/interface[@type='graph']/svg:svg"/>
	</xsl:template>

	<xsl:template match="svg:g[svg:title/text()=/jobState/jobLink/@taskRef]">
		<xsl:variable name="subJobId" select="/jobState/jobLink[@taskRef=current()/svg:title/text()]/@jobId" />
		<xsl:variable name="subJobDoc" select="document(concat($subJobId,'/index.xml'))" />
		<xsl:variable name="subTaskPID" select="$subJobDoc/jobState/*/head/name/text()" />
		<xsl:variable name="subJobPID" select="concat($subTaskPID,'.',substring-after($subJobId,concat($subTaskPID,'/')))" />
		<svg:a target="_top" xlink:href="#jobs::{$jobPID}::{$subJobPID}">
			<xsl:attribute name="class"><xsl:text>jobstatus </xsl:text><xsl:value-of select="$subJobDoc/jobState/status/value" /></xsl:attribute>
			<xsl:call-template name="nodeCopy" />
		</svg:a>
	</xsl:template>

</xsl:stylesheet>