<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" xmlns:xhtml="http://www.w3.org/1999/xhtml">
  
  <xsl:output method="html" indent="yes" />	

  <xsl:include href="ident.xsl" />
  
  <xsl:param name="jobUrl" />

  <xsl:param name="previewDataLimit">1048576</xsl:param>  
  
  <xsl:variable name="job" select="document($jobUrl)"/>
  
  <xsl:variable name="htdocs">/portal/</xsl:variable>
  
  <xsl:variable name="server" select="''" />  

  <xsl:template match="*">
    <xsl:element name="{local-name()}">
      <!-- go process attributes and children -->
      <xsl:apply-templates select="@*|node()"/>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="@*">
    <xsl:attribute name="{local-name()}">
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="/viewer">
    <html>
      <head>
        <title>Mobyle - <xsl:value-of select="head/name/text()"/></title>
        <link rel="stylesheet" href="{$htdocs}css/mobyle.css" type="text/css" media="screen" />
        <link rel="stylesheet" href="{$htdocs}css/local.css" type="text/css" media="screen" />
      </head>
      <body>
        <div class="viewer">
          <div class="header">
            <xsl:apply-templates select="head" mode="serviceHeader"/>
          </div>      
          <xsl:if test="$jobUrl">
            <div class="data_view">
              <xsl:apply-templates select="head/interface[@type='viewer']/*"/>          
            </div>
          </xsl:if>
          <div>
    	  <xsl:apply-templates select="head" mode="serviceFooter"/>
          </div>
        </div>
      </body>
      </html>
  </xsl:template>

  <xsl:template match="xhtml:*[@data-paragraphname]">
    <!-- do not display a paragraph unless there are data to be displayed -->
    <xsl:if test="$job/jobState/data//*[name/text()=current()//@data-parametername]">
      <xsl:element name="{local-name(.)}">
        <xsl:apply-templates select="@*|node()" />
      </xsl:element>
    </xsl:if>
  </xsl:template>

 
  <xsl:template match="@*">
    <xsl:choose>
      <xsl:when test="../@data-parametername and .='data-url'">
        <xsl:variable name='parametername' select="../@data-parametername"/>
        <xsl:variable name="data-url" select="$job/jobState/data[parameter/name/text()=$parametername]/file/text()"/>            
        <xsl:attribute name="{name()}" namespace="{namespace-uri()}"><xsl:value-of select="$data-url"/></xsl:attribute>        
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>