<?xml version="1.0" encoding="utf-8"?>
<!-- 
	form_graph.xsl stylesheet
	Authors: Hervé Ménager
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:svg="http://www.w3.org/2000/svg">

	<xsl:include href="ident.xsl" />

	<xsl:template match="svg:*/@style" />
	<xsl:template match="svg:*/@fill" />
	<xsl:template match="svg:*/@stroke" />
	<xsl:template match="svg:*/@font-family" />
	<xsl:template match="svg:*/@font-size" />
	
	<xsl:template match="interface[@type='graph']/svg:svg">
		<xsl:copy>
			<xsl:apply-templates select="@*" />     
			<xsl:attribute name="viewBox"><xsl:text>0 0 </xsl:text><xsl:value-of select="substring-before(@width,'pt')" /><xsl:text> </xsl:text><xsl:value-of select="substring-before(@height,'pt')" /></xsl:attribute>
			<style>
				g{
					fill: white; stroke:black; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 14px;
				}

				text{
					fill: black; stroke: none;
				}				

                .jobstatus.building text{
                    fill: darkorange;
                }
                
                .jobstatus.submitted text, .jobstatus.pending text, .jobstatus.running text, .jobstatus.hold text{
                    fill: darkorange;
                }
                
                .jobstatus.error text, .jobstatus.killed text{
                    fill: red;
                }
                
                .jobstatus.finished text{
                    fill: green;
                }
                
                a.jobstatus:hover{
                	stroke-width: 2px;
                }
            </style>
			<xsl:apply-templates select="node()|text()" />
		</xsl:copy> 
	</xsl:template>	

</xsl:stylesheet>
