#!/usr/bin/env python

import os
import urllib
import pygraphviz as pgv  #@UnresolvedImport
import simplejson

import mb_cgi
#import cgitb; cgitb.enable()

import sys, random, shutil,re
from lxml import etree
from Mobyle.JobFacade import JobFacade
from Mobyle.Workflow import Workflow, Task, Parameter, Link, Type, Datatype, Biotype, InputValue, Value, VElem, Vlist,\
    Parser
from  Mobyle.Parser import parseService
from Mobyle.DataInputsIndex import DataInputsIndex
from Mobyle.Classes.DataType import DataTypeFactory
from Mobyle.Registry import registry
import Mobyle.Net
from Mobyle.MobyleError import SessionError, UserValueError, MobyleError

from Mobyle.AuthenticatedSession import AuthenticatedSession
from Mobyle.AnonymousSession import AnonymousSession 
from Mobyle.JobState import url2path
from Mobyle.JobState import JobState, ProgramJobState

# Library import for application category classification
from Mobyle.Registry import CategoryDef, registry, ServiceTypeDef
from Mobyle.ClassificationIndex import ClassificationIndex
from Mobyle.InterfacePreprocessor import InterfacePreprocessor
from Mobyle.Utils import emailHelpRequest

# This CGI script will be used for generic services for the Mobyle Workflow projects
# the form field 'action' will be used for deciding the functions performed. The possible
# values of 'action' field are 
# action=get_all_wfs
# action=get_wf&wf_name=xxx
# action=upload_wf_graphml&graphml=xxx&wf_name=yyy
# action=rename_wf&wf_from_name=xxx&wf_to_name=yyy
# action=delete_wf&wf_name=xxxx
# action=graphviz_layout&wf_name=xxxx

# Vivek Gopalan 05JAN2010

try: # Windows needs stdio set for binary mode.
    import msvcrt
    msvcrt.setmode (0, os.O_BINARY) # stdin  = 0
    msvcrt.setmode (1, os.O_BINARY) # stdout = 1
except ImportError:
    pass

import sys, os, glob, re

graphmlFileName = ".workflow_template_graphml.xml"

def update_workflow_from_graphml(session_workflows_dir,workflow_name):
    """update the workflow files stored on the server from the corresponding up-to-date graphml file"""
    cgi_file_path = os.path.join(os.path.dirname(__file__))
    graphml_to_wf_xsl_path = cgi_file_path + '/graphml_to_wf.xsl'
    wf_graphml_file = session_workflows_dir + '/' + workflow_name + ".graphml"
    wf_file = session_workflows_dir + '/' + workflow_name + '.xml'
    xslProcess(graphml_to_wf_xsl_path, wf_graphml_file, wf_file)
    yy = open(wf_file, 'r').read()
    mobyle_parser = Parser()
    o = mobyle_parser.XML(yy)
    wf_tasks_file = session_workflows_dir + '/' + 'tasks.xml' 
    if os.path.exists(wf_tasks_file):
        doc = etree.parse(wf_tasks_file, parser)
        root = doc.getroot()
        for wf_task_ele in o.findall("flow/task"):
            task_id = wf_task_ele.get('id')
            task_inp_values = root.find("task[@id='%s']" % task_id)
            if (task_inp_values is not None):
                for inp in list(task_inp_values):
                    wf_task_ele.append(inp) 
    wf_out_name = workflow_name + '_mobyle.xml'
    open(session_workflows_dir + '/' + wf_out_name, 'w').write(mobyle_parser.tostring(o, pretty_print=True))
    # generate input and output parameters for Mobyle integration
    mobyle_parser = Parser()
    yy = open(session_workflows_dir + '/' + wf_out_name, 'r').read()
    wf = mobyle_parser.XML(yy)
    for task in wf.tasks:
        service = parseService(registry.serversByName['local'].programsByName[task.service].path)
        # create input parameters
        for input_parameter_name in service.getUserInputParameterByArgpos():
            # if the value of the parameter is not provided by a link
            if not([link for link in wf.links if (input_parameter_name==link.to_parameter and task.id==link.to_task)]):
                input_parameter = service.getParameter(input_parameter_name)
                parameter = Parameter()
                # input parameter name is: service name + "_" + parameter name to avoid collisions
                # TODO: should be task id + "_" + parameter name
                parameter.name = service.getName() + "_" + input_parameter.getName()
                parameter.prompt = input_parameter.getPrompt()
                parameter.type = Type()
                parameter.type.biotypes = [Biotype(bt_str) for bt_str in input_parameter.getBioTypes()]
                parameter.type.datatype = Datatype()
                parameter.type.datatype.class_name = input_parameter.getDataType().name
                if input_parameter.getDataType().name!=str(input_parameter.getDataType().getRealName()):
                    parameter.type.datatype.superclass_name = str(input_parameter.getDataType().getRealName())
                parameter.id = parameter.name
                if input_parameter.ismandatory() and (len(input_parameter.getPreconds())==0):
                    parameter.ismandatory = True
                if input_parameter.issimple():
                    parameter.issimple = True                        
                # setting default value (vdef)
                vdefs = []
                for iv in [iv for iv in task.input_values if iv.name==input_parameter_name]:
                    value = Value()
                    if iv.reference is not None:
                        value.src = iv.reference
                        value.srcFileName = [iv_filename.value for iv_filename in task.input_values if iv_filename.name==iv.name+'.srcFileName'][0]
                    elif iv.value is not None:
                        value.value = iv.value
                    vdefs.append(value)
                if not(vdefs) and input_parameter.getVdef():
                    value = Value()
                    value.value = input_parameter.getVdef()
                    vdefs.append(value)
                if vdefs:
                    parameter.vdef = vdefs
                #setting vdef
                if input_parameter.hasVlist():
                    vlist = Vlist()
                    for key, value in input_parameter._vlist.items():
                        velem = VElem()
                        velem.label = key
                        velem.value = value
                        vlist.velems = vlist.velems + [velem]
                    parameter.vlist = vlist
                if input_parameter.hasFlist():
                    vlist = Vlist()
                    for key, value in input_parameter._flist.items():
                        velem = VElem()
                        velem.label = value[0]
                        velem.value = key
                        vlist.velems = vlist.velems + [velem]
                    parameter.vlist = vlist
                wf.parameters = wf.parameters + [parameter]
                link = Link()
                link.to_parameter=input_parameter_name
                link.to_task = task.id
                link.from_parameter = parameter.id
                wf.links = wf.links + [link]
    yy = open(session_workflows_dir + '/' + wf_out_name, 'w')
    yy.write(mobyle_parser.tostring(wf))
    yy.close()
    # now generating a Mobyle-style interface to enable display of BMW jobs in Mobyle Portal
    preprocessor = InterfacePreprocessor()
    preprocessor.process_interface(session_workflows_dir + '/' + wf_out_name)
    return wf_out_name


def get_all_wfs(directory):                                        
    "get list of file info objects for files of particular extension" 
    file_list = os.listdir(directory)                    
    test = re.compile("\.graphml$", re.IGNORECASE)
    wf_name_list = []
    for f in file_list :
        if (test.search(f)) :
            wf_name_list.append(re.sub("\.graphml$", "", f))
    return wf_name_list 

def intersect(seq1, seq2):
    res = []                     # start empty
    for x in seq1:               # scan seq1
        if x in seq2:            # common item?
            res.append(x)        # add to end
    return res

def get_classification(lines):
    root_node = treenode.TreeNode("All apps");
    node_data = {}
    line_iter = iter(lines)
    while 1:
        try:
            line = line_iter.next()
            line = line.rstrip()
            fields = line.split(':')
            prog_name = fields.pop(0)
            fields.append(prog_name)
            no_of_fields = len(fields)
            for i in range(1, no_of_fields) :
                child = fields[i];
                parent = fields[ i - 1 ]
                
                id = ":".join(fields[0: i]);
        
                if node_data.has_key(id) :
                    node = node_data[id]
                else :
                    node = treenode.TreeNode(parent)
                    node_data[id] = node
                    if i == 1 :
                       root_node.add_child(node)
                       
                if not node.has_child_with_name(child) :
                    child_node = treenode.TreeNode(child)
                    node.add_child(child_node)
                    id = ":".join(fields[0:i + 1])
                    #message += "%s -- %s  i=%d<BR>" % (id,":".join(fields[0:2]),i)
                    node_data[id] = child_node
        except StopIteration:
            break
    return root_node

def get_pipeout_params(program_name, param_name,classification_list ):
    out_param_list=[]
    pdi = DataInputsIndex("program")
    vdi = DataInputsIndex("viewer")
    #program_name = 'clustalw-multialign'
    #param_name = 'newtreefile'
    program_url = registry.serversByName['local'].programsByName[program_name].url
    service = parseService(program_url)
    inp_datatype = service.getDataType(param_name)
    inp_biotypes = service.getBioTypes(param_name)
    df = DataTypeFactory()
    dataInputsList = pdi.getList().values() + vdi.getList().values()
    
    for parameter in dataInputsList:
        try:
            if parameter.get('dataTypeSuperClass'):
                dt = df.newDataType(parameter.get('dataTypeSuperClass'), parameter.get('dataTypeClass'))
            else:
                dt = df.newDataType(parameter.get('dataTypeClass'))
            if dt.isMultiple():
                dt = dt.dataType
        except MobyleError, me:
            mb_cgi.c_log.warning(me)
            continue
        datatype_match = True
        biotype_match = True
        bio_types = parameter.get('biotypes')
        if (inp_biotypes is not None and bio_types is not None and len(intersect(inp_biotypes, bio_types)) == 0):
            biotype_match = False
        if inp_datatype.name not in dt.ancestors:
            datatype_match = False
        if (datatype_match and biotype_match):
            pattern = re.compile("%s:" % parameter.get('programName'))
            subs_val = parameter.get('programName') + '|' + parameter.get('name') + ":"
            c= [re.sub(pattern,subs_val,l.rstrip()) for  l in classification_list if (pattern.match(l.rstrip()) is not None)]
            if c:
                out_param_list.extend(c)
    return out_param_list
              
    

def get_pipeout_status(program_name,param_name,params_string):
    out_status_list=[]
    pdi = DataInputsIndex("program")
    vdi = DataInputsIndex("viewer")
    #program_name = 'clustalw-multialign'
    #param_name = 'newtreefile'
    program_url = registry.serversByName['local'].programsByName[program_name].url
    service = parseService(program_url)
    inp_datatype = service.getDataType(param_name)
    inp_biotypes = service.getBioTypes(param_name)
    df = DataTypeFactory()
    dataInputsList = pdi.getList().values() + vdi.getList().values()
    
    params_list = params_string.split(",")
    status_hash ={}
    
    for parameter in dataInputsList:
        try:
            if (parameter.get('programName') + ':' + parameter.get('name') not in params_list):
               continue
            if parameter.get('dataTypeSuperClass'):
               dt = df.newDataType(parameter.get('dataTypeSuperClass'), parameter.get('dataTypeClass'))
            else:
               dt = df.newDataType(parameter.get('dataTypeClass'))
            if dt.isMultiple():
                dt = dt.dataType
            datatype_match = True
            biotype_match = True
            bio_types = parameter.get('biotypes')
            if (inp_biotypes is not None and bio_types is not None and len(intersect(inp_biotypes, bio_types)) == 0) :
                bioTypes = False
            if inp_datatype.name not in dt.ancestors:
                datatype_match = False
            if (datatype_match and biotype_match):
                  status_hash[parameter.get('programName') + ':' + parameter.get('name')] = True
        except:
            mb_cgi.c_log.error("Error computing pipes", exc_info=True)
    for x in params_list:            
        if(status_hash.has_key(x)):
            out_status_list.append("True")
        else:
            out_status_list.append("False")
            
    return ",".join(out_status_list)
# get CGI form fields

# Import modules

import time, treenode

#session id

# tmp data directory
parser = etree.XMLParser(no_network=False)

class CustomResolver(etree.Resolver):
    """
    CustomResolver is a Resolver for lxml that allows (among other things) to
    handle HTTPS protocol, which is not handled natively by lxml/libxml2
    """
    def resolve(self, url, id, context):
        return self.resolve_file(urllib.urlopen(url), context)

parser = etree.XMLParser(no_network=False)
parser.resolvers.add(CustomResolver())
    
def xslProcess(xsl_file,xml_source,xml_target,params={}):
    global parser
    xslt_doc = etree.parse(xsl_file,parser)
    transform = etree.XSLT(xslt_doc)
    parser = etree.XMLParser( no_network = False )
    xml = etree.parse(xml_source,parser)
    xml = transform(xml, **params)
    target_file = open(xml_target,"w")
    target_file.write(str(xml))
    target_file.close()
    
def process(self):
# action form field value
    form = self.request
    action_name = form['action'].value
    self.message = ''
    
    sess_id = self.sessionKey

    self.anonymousSession = self.session
    
    if action_name == 'get_portal_config':
        # used by BMPS to get the Mobyle authentication possibilities according to the current configuration
        self.mime_type="application/json"
        self.message = '{"anonymous_session":"%s","authenticated_session":"%s"}' % (self.cfg.anonymousSession(), self.cfg.authenticatedSession())
    if (action_name != 'login' and action_name != 'logout') :
        tmp_data_dir = os.path.realpath( os.path.join(self.session.getDir(), 'BMW' ))
        # Bug: This needs to be changed. Workflow name should be prepended to the
        # file or the better solution is to directly save the content to the
        # workflow XML instead of writing to the tasks.xml - Vivek gopalan 15NOV2011
        wf_tasks_file = tmp_data_dir + '/' + 'tasks.xml' 
        wfSessionDirName = AuthenticatedSession.DIRNAME if self.session.isAuthenticated() else AnonymousSession.DIRNAME
        if not os.path.exists(tmp_data_dir):
            os.makedirs( tmp_data_dir, 0755 ) #create parent directory
        tmp_url = "%s/%s/%s/%s" % ( self.cfg.user_sessions_url(),wfSessionDirName,sess_id,'BMW') 
        user_sess_url = "%s/%s/%s" % ( self.cfg.user_sessions_url(),wfSessionDirName,sess_id ) 
    
    if action_name == 'graphviz_layout' :
        # action=graphviz_layout&wf_name=xxxx[&graphml_content=xxx&output_graphml=1
        wf_name = form['wf_name'].value
        tmp_data_dir = os.path.abspath(tmp_data_dir)
        wf_graphml_file = tmp_data_dir + '/' + wf_name + '.graphml'
        if (form.has_key('graphml_content')) :
            graphml_content = form['graphml_content'].value
            open(wf_graphml_file, 'wb').write(graphml_content)
        tmp_graphviz_dir = "%s/graphviz_%d" % (tmp_data_dir, random.randint(1, 100000))
        os.mkdir(tmp_graphviz_dir, 02770)
        wf_dot_file = tmp_graphviz_dir + '/' + wf_name + '.dot'
        wf_modified_graphml_file = tmp_graphviz_dir + '/' + wf_name + '.graphml'
        wf_css_file = tmp_graphviz_dir + '/cmap.css'
        cgi_file_path = os.path.join(os.path.dirname(__file__))
        graphml_to_dot_xsl_path = cgi_file_path + '/graphml_to_dot.xsl';
        update_graphml_with_layout_xsl_path = cgi_file_path + '/update_graphml_with_graphviz_layout.xsl';
        
        xslProcess(graphml_to_dot_xsl_path, wf_graphml_file, wf_dot_file)
        G=pgv.AGraph(wf_dot_file)
        G.layout(prog='dot')
        G.draw(wf_css_file,format='cmapx')
        shutil.copy(update_graphml_with_layout_xsl_path, tmp_graphviz_dir)
        xslProcess("update_graphml_with_graphviz_layout.xsl", wf_graphml_file, wf_modified_graphml_file,params={'cssPath':"'"+wf_css_file+"'"})
        if (os.path.exists(wf_modified_graphml_file)) :
            shutil.copyfile(wf_modified_graphml_file, wf_graphml_file)
        if (form.has_key('output_graphml')) :
            self.message = open(wf_modified_graphml_file, 'r').read()
        else :
            self.message = "/usr/bin/xsltproc " + "-o  " + wf_modified_graphml_file + " update_graphml_with_graphviz_layout.xsl " + wf_graphml_file

    elif action_name =='login':
        # login = login to an authenticated session
        # replies a JSON message: 
        # 'status' is true/false according to authentication success/fail
        # 'message' is an optional error message (if authentication fails)
        # 'source' is the invalid field name (interface should focus on it)
        self.mime_type="application/json"
        response = {'status':True}
        email          = form.getfirst('email')
        password       = form.getfirst('password')
        create_account = False
        try:
            mobyle_email = Mobyle.Net.EmailAddress( email )
        except MobyleError:
            response = {'status':False, 'source' : 'email','message': 'Invalid e-mail, please provide a valid address'}
        else:
            if form.has_key('create_account') and form.getfirst('create_account') == 'yes' :
                create_account = True 
                if (create_account == True) :
                    try:
                        self.session = self.sessionFactory.createAuthenticatedSession( mobyle_email, password)
                    except Exception, e:
                        mb_cgi.c_log.error("error creating a session: %s" % str(e), exc_info=True)
            try:
                self.anonymousSession = self.session
                self.session = self.sessionFactory.getAuthenticatedSession(mobyle_email,passwd=password)
                if self.anonymousSession and self.anonymousSession != self.session:
                    self.session.mergeWith(self.anonymousSession)
                self.sessionKey = self.session.getKey()
                self.read_session()
                self.message = str(True)
            except SessionError, e:
                response = {'status':False, 'source' : 'email','message': str(e)}
        self.message = simplejson.dumps(response, encoding='ascii')

    elif action_name =='validate_guest_access':
        # validate_guest_access = provide an email and/or captcha if necessary to submit
        # jobs as a guest
        # replies a JSON message: 
        # 'status' is true/false according to authentication success/fail
        # 'message' is an optional error message (if authentication fails)
        # 'source' is the invalid field name (interface should focus on it)
        self.mime_type="application/json"
        email          = form.getfirst('email')
        captcha_answer       = form.getfirst('captcha_answer')
        response = {'status':True}
        try:
            self.session.setEmail(Mobyle.Net.EmailAddress(email))
        except MobyleError:
            response = {'status':False, 'source' : 'email','message': 'Invalid e-mail, please provide a valid address'}
        else:
            try:
                ok = self.session.checkCaptchaSolution(captcha_answer)
            except MobyleError:
                ok = False
            if not(ok):
                response = {'status':False, 'source' : 'captcha','message': 'Wrong answer, try again'}
        self.message = simplejson.dumps(response, encoding='ascii')
    elif action_name =='logout':
        try:
            if (self.cfg.anonymousSession()!='no'):
                self.session = self.sessionFactory.getAnonymousSession()
                self.sessionKey = self.session.getKey()
            else: 
                self.session = None
                self.sessionKey = None
            self.read_session()

            self.message = str(True)
        except SessionError, e:
            self.message  = str(False)
            self.message  += " - " +str(e)

    elif action_name == 'get_all_wfs' :
    # action=get_all_wfs
        wf_files = get_all_wfs(tmp_data_dir)
        if wf_files :
           self.message = ",".join(wf_files)
    elif action_name == 'list_workflow_with_description':
        session_folder = self.session.getDir()
        workflow_list = list_workflow_with_description(session_folder)
        self.message = simplejson.dumps(workflow_list)
    elif action_name == 'send_job_report' :
        emailHelpRequest(self.cfg, self.session.getEmail(), \
                         registry, self.request.getfirst('id',None), \
                         form.getfirst('message',None), self.session, \
                         self.request.getfirst('param',None), \
                         self.request.getfirst('message',None)) 
        self.message = "True"
    elif action_name == 'get_wf' :
    #action=get_wf&wf_name=xxx
        wf_name = form['wf_name'].value
        wf_file = tmp_data_dir + '/' + wf_name + '.graphml'
        if (os.path.exists(wf_file)) :
           self.message = open(wf_file, 'r').read()
        else :
            self.message = "<graphml/>";
    elif action_name == 'upload_wf_graphml' :
        # create/delete the workflow using uploaded graphml file
        # action=upload_wf_graphml&graphml=xxx&wf_name=yyy
        graphml_content = form['graphml'].value
        #outfile_name = "wf_%d.graphml" % (random.randint(1, 100000))
        outfile_name = form['wf_name'].value + '.graphml';
        open(tmp_data_dir + '/' + outfile_name, 'wb').write(graphml_content)
        wf_out_name = update_workflow_from_graphml(tmp_data_dir,form['wf_name'].value)
        self.message = "<a href ='" + tmp_url + '/' + wf_out_name + "' target='_blank'>" + wf_out_name + "</a>"
    elif action_name == 'delete_wf' :
        # delete the workflow
        # action=delete_wf&wf_name=xxxx
        wf_name = form['wf_name'].value
        file_path_prefix = tmp_data_dir + '/' + wf_name
        if os.path.exists(file_path_prefix + ".graphml") :
            for path in [file_path_prefix + ext for ext in [".graphml",".xml","_mobyle.xml"]]:
                os.remove(path)
        self.message = "SUCCESS"
    elif action_name == 'rename_wf' :
        # rename the workflow
        # action=rename_wf&wf_from_name=xxx&wf_to_name=yyy
        from_file = form['wf_from_name'].value
        to_file = form['wf_to_name'].value
        from_file_path_prefix = tmp_data_dir + '/' + from_file
        to_file_path_prefix = tmp_data_dir + '/' + to_file
        graphml_modified = False
        if not os.path.exists(from_file_path_prefix+".graphml"):
            # create source workflow if it does not exist
            open(from_file_path_prefix + ".graphml", 'wb').write('<graphml/>')
            graphml_modified = True
        if 'wf_description' in form:
            # edit workflow description
            to_description = form['wf_description'].value or ''
            source_file = open(from_file_path_prefix+".graphml", 'r')
            root_tree = etree.parse(source_file)
            source_file.close()
            graph = root_tree.find('graph')
            mb_cgi.c_log.error(graph)
            if graph is None:
                graph = etree.SubElement(root_tree.find('.'), 'graph')
            #TODO: "description" attribute is taken from HPCWeb branch,
            # however according to the workflow graphml spec it should be the
            # contents of a <data key="description"/> element
            # or according to the graphml spec a <desc> element...
            if graph.get('description')!=to_description:
                graph.set('description', to_description)
                wffile = open(from_file_path_prefix+".graphml", 'w' )
                wffile.write( etree.tostring(root_tree)) 
                wffile.close()
                graphml_modified = True
        if graphml_modified:
            # propagate graphml modifications to Mobyle XML if relevant
            update_workflow_from_graphml(tmp_data_dir, from_file)
        if not os.path.exists(from_file_path_prefix+".graphml"):
            # create workflow if it does not exist
            open(to_file_path_prefix + ".graphml", 'wb').write('<graphml/>')
            update_workflow_from_graphml(tmp_data_dir, from_file)
        if os.path.exists(from_file_path_prefix + ".graphml") :
            for from_path, to_path in [(from_file_path_prefix + ext, to_file_path_prefix + ext) for ext in [".graphml",".xml","_mobyle.xml"]]:
                os.rename(from_path, to_path)
        self.message = "SUCCESS"
    elif action_name == 'get_apps_class_future':
        self.mime_type="application/json"
        p_classification = ClassificationIndex("program")
        #TODO: before to use the workflows:
        # - they should be made "draggable" into the canvas area (currently it crashes the editor)
        # - the issue of user defined workflows appearing there should be solved
        #w_classification = ClassificationIndex("workflow")
        p_classification.buildRegistryCategories(field=self.request.getfirst('classifyBy','category'),serviceTypeSort=self.request.getfirst('serviceTypeSort','separate'))
        #w_classification.buildRegistryCategories(field=self.request.getfirst('classifyBy','category'),serviceTypeSort=self.request.getfirst('serviceTypeSort','separate'))
        def generate_classification(node):
            json_node = {'name': node.name}
            children = []
            for c in node.getChildCategories():
                children.append(generate_classification(c))
            for s in node.getChildServices():
                children.append({'name':s.name})
            if len(children)>0:
                json_node['children']=children
            return json_node
        registry.name = "All apps"
        programs = [c for c in registry.getChildCategories() if c.name=="Programs"][0]
        classification =generate_classification(programs)
        self.message = simplejson.dumps({"status":"success","details":classification,"message":"success"}, encoding='ascii')
    elif action_name == 'get_apps_class' :
        #file = open('mobyle_class.conf', 'r')
        type = 'program'
        field ='category'

        # fetch the Classification index (generated by mobdeploy command)
        p_classification = ClassificationIndex(type)
        index = p_classification.index
        classifications = []
        for s in getattr( registry, type + 's'):
	   cats = index[s.url][field]
	   for cn in cats:# for each classification of the program
                out = s.name.strip()+ ':' + cn.strip()
                out = re.sub("\s*:\s*",":",out); # remove space around the :
		classifications.append(out)
        if form.has_key('app_name'):
            app_name = form.getfirst('app_name')
            param_name = form.getfirst('param_name')
            classfication_list = get_pipeout_params(app_name, param_name,classifications)
            root_node1 = get_classification(classfication_list)
            self.message += '{"status":"success","details": ' + root_node1.to_json_str() + ',"self.message":"success"}'
        elif form.has_key('format') and form.getfirst('format') == 'app_names_only':
           app_names_list=[]
           for classification in classifications:
	      app_names_list.append(re.sub(":.*$","",classification))
           self.message += '{"status":"success","details": {"files": ["' + '","'.join(app_names_list)+ '"]},"message":"success"}'
        else:
            root_node = get_classification(classifications)
            self.message += '{"status":"success","details": ' + root_node.to_json_str() + ',"message":"success"}'
        #file.close()
    ## print the self.message as reponse
    elif action_name == 'check_pipeins' :
            app_name = form.getfirst('app_name')
            param_name = form.getfirst('param_name')
            params = form.getfirst('params')
            out = get_pipeout_status(app_name,param_name, params)
            self.message += out
    
    elif action_name == 'form_submit' :
        
       task_id = form.getfirst('app_id')
       if os.path.exists(wf_tasks_file):
           doc = etree.parse(wf_tasks_file, parser)
           root = doc.getroot()
           task_inp_values = root.find("task[@id='%s']" % task_id)
           if (task_inp_values is not None):
               root.remove(task_inp_values)
       else:
           root = etree.Element("tasks")
           
       field_list = '<task id="%s">\n' % task_id
       field_list_txt = '<br/>\n'
       for field in form.keys():
           if field == 'action' or field == 'form_submit' or field == 'app_id' or field == 'from_app':
               continue
           for value in form.getlist(field) :
                if value and len(value.strip())>0:
                   if (".ref" in field) :
		      field_list = field_list + '<inputValue name="%s" reference="%s" />\n' % (field.replace(".ref",""),user_sess_url)
                      field = field.replace(".ref",".srcFileName")
                   field_list = field_list + '<inputValue name="%s">%s</inputValue>\n' % (field, value)
                   field_list_txt = field_list_txt + '%s:%s<br/>\n' % (field, value)
       field_list = field_list + '</task>\n'
       task_node = etree.fromstring(field_list, parser=parser)
       root.append(task_node)
       field_list_txt = field_list_txt + '<br/>\n'
       
       open(wf_tasks_file, 'wb').write(etree.tostring(root))
       #self.message = etree.tostring(root) 
       self.message = "Saved successfully.."
       
    elif action_name == 'get_app_xml' :
        app_name = form.getfirst('app_name')
        task_id = form.getfirst('app_id')
        job_id = form.getfirst('job_id')
        app_xml_file = registry.getProgramPath(app_name)
       # the program XML file should be read only from the registry since the
        # xinclude options are correctly processed in that file.
        # Since interface tag is not used in the project it should be removed
        # to save data transfer time to client - Vivek Gopalan 15NOV2011
        if not os.path.exists(app_xml_file):
            app_xml_file = MOBYLEHOME + '/Local/Services/Programs/' + app_name + ".xml"
        # Fix me: This file should not be global. It causes unpredicatable
        # result now  Vivek (15 Nov 2011)
        values = []
	if job_id is not None:
           jobUrl = registry.getJobURL(job_id);
           job = self.session.getJob(jobUrl);
           jobState = JobState(jobUrl)
           params = []
	   for param_name,value in jobState.getInputFiles() or []:
	     params.append(param_name)
	   for param_name,value in jobState.getArgs().items() :
	      if param_name in params:
	           for data_id in job['dataUsed']:
		      data = self.session.getData(data_id)
                      if data['userName'] == value :
	      	         value = data_id + ',' + job['jobID'] + '/' + value
              values.append((param_name,value))
           program_node = set_default_value(app_xml_file,values)
           self.message = etree.tostring(program_node)
        elif os.path.exists(wf_tasks_file):
           doc = etree.parse(wf_tasks_file, parser)
           root = doc.getroot()
           task_inp_values = root.find("task[@id='%s']" % task_id)
           values = []
           if (task_inp_values is not None):
              for inp in list(task_inp_values):
	        values.append((inp.get("name"), inp.text)) 
	   program_node = set_default_value(app_xml_file,values)
           self.message = etree.tostring(program_node)
      	else :
	   self.message = etree.tostring(set_default_value(app_xml_file,values))
    elif action_name == 'get_job_graphml':
       wfId =self.request.getfirst('id',None)
       self.message = get_formatted_job_entries(wfId,self.session)

def set_default_value(app_xml_file,task_inp_values):
   program_node = None
   if (task_inp_values is not None):
       program_node = etree.parse(app_xml_file)
       for param_name, value in list(task_inp_values):
	  params = program_node.xpath(".//parameters/parameter[name=\"%s\"]" % param_name)
	  for param in params:
	      vdef_node = param.find('vdef')
	      if vdef_node is not None:
		  param.remove(vdef_node)
       for param_name, value in list(task_inp_values):
	  vdef_new = etree.Element("vdef")
	  value_node = etree.Element("value")
	  value_node.text = value
	  vdef_new.append(value_node) 
	  params1 = program_node.xpath(".//parameters/parameter[name=\"%s\"]" % param_name)
	  for param1 in params1:
	      param1.append(vdef_new)
   else:
	if os.path.exists(app_xml_file):
	   program_node = etree.parse(app_xml_file)
   if program_node is not None:
      _remove_from_parent(program_node,".//interface")
      _remove_from_parent(program_node,".//parameter/[name='stdout']")
      _remove_from_parent(program_node,".//parameter/[name='stderr']")
   return program_node 

def _remove_from_parent(node,xpath_str) :
   eles = node.findall(xpath_str)
   for el in eles:
      el.getparent().remove(el)

def get_formatted_job_entries(wfId,session):
   wfUrl = registry.getJobURL(wfId);
   wfJob = session.getJob(wfUrl);
   jf = JobFacade.getFromJobId( wfJob[ 'jobID' ] )
   wfState = JobState(wfUrl)
   wfJob['subjobs']  = jf.getSubJobs() 
   graphmlAbsPath = os.path.join(url2path(wfJob['jobID']), graphmlFileName)
   doc = etree.parse(graphmlAbsPath, parser)
   root = doc.getroot()


   for data_ele in root.xpath("graphml/graph/data/@workflowJobStatus"):
      data_ele.getParent().remove(data_ele)
   if (wfJob['status']) :
       for data_ele in root.xpath('/graphml/graph'):
            dataNode = etree.Element("data")
            dataNode.set("key","workflowJobStatus")
            dataNodeStatus = etree.Element("value")
            dataNodeStatus.text = str(wfJob['status'])
            dataNodeMessage = etree.Element("message")
            dataNodeMessage.text = wfJob['status'].message
            dataNode.append(dataNodeStatus)
            dataNode.append(dataNodeMessage)
            data_ele.append(dataNode)

   for data_ele in root.xpath("graphml/graph/node/data/@processJobStatus"):
      data_ele.getParent().remove(data_ele)
   if wfJob.has_key('subjobs') and wfJob['subjobs'] is not None:
       for subjob in wfJob['subjobs']:
            jobUrl = subjob['jobID']
            taskRef = wfState.root.xpath( 'jobLink[@jobId="%s"]/@taskRef' % jobUrl)
            if ( taskRef and len(taskRef) > 0) :
                for data_ele in root.xpath('/graphml/graph/node[@id="%s"]' % taskRef[0]):
                   dataNode = etree.Element("data")
                   dataNode.set("key","processJobStatus")
                   dataNodeStatus = etree.Element("value")
                   dataNodeStatus.text = str(subjob['status'])
                   dataNodeMessage = etree.Element("message")
                   dataNodeMessage.text = subjob['status'].message
                   dataNode.append(dataNodeStatus)
                   dataNode.append(dataNodeMessage)
                   data_ele.append(dataNode)
   return etree.tostring(root,method="xml", pretty_print=True)
#print """\
#        Set-Cookie: sid=%s
#        Content-Type: text/html\n
#%s""" % (sid, self.message)

#finally close the session..
#sess.close()

def sorted_ls(path):
    mtime = lambda f: os.path.getctime(os.path.join(path, f))
    return list(sorted(os.listdir(path), key=mtime))

def get_workflow_description(session_folder, workflow_name):
    """get the description of the workflow

    workflow_name: workflow name
    return: description
    """
    import os
    source_folder = os.path.realpath(os.path.join(session_folder, 'BMW'))
    source_filename = os.path.realpath(os.path.join(source_folder, workflow_name + '.graphml'))
    from lxml import etree
    if not os.path.exists(source_filename):
        return ''
    source_file = open(source_filename, 'r')
    description = ''
    try:
        root_tree = etree.parse(source_file)
        element = root_tree.find('graph')
        description = element.get('description')
        if description is None:
            description = ''
    except Exception:
        pass
    finally:
        source_file.close()
    return description

def list_workflow_with_description(session_folder):
    """list workflow with their description

    session_folder: user session folder
    return: list of workflow name and list of workflow description
    """
    import os
    source_folder = os.path.realpath(os.path.join(session_folder, 'BMW'))
    sorted_filename_list = sorted_ls(source_folder)
    import re
    pattern = re.compile('\.graphml$', re.IGNORECASE)
    workflow_name_list = []
    workflow_description_list = []
    for filename in sorted_filename_list :
        if pattern.search(filename):
            workflow_name = re.sub('\.graphml$', '', filename)
            workflow_name_list.append(workflow_name)
            workflow_description = get_workflow_description(session_folder, workflow_name)
            workflow_description_list.append(workflow_description)
    return [workflow_name_list, workflow_description_list]

if __name__ == "__main__":
   mb_cgi.HTMLCGI(processFunction=process,useSession=True)

