
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ctype.h>

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#include "mytag.h"
#include "error.h"
#include "pat.h"

#define BUFSIZE 100


int getplist(pat_t *p,FILE *IN) {
  char c;
  char *buf, *ebuf, *isbuf, *iebuf;
  int bufsize, plen;

  /* no more pattern */
  if ((c = fgetc(IN)) == EOF) return EOF;
  else if (ungetc(c, IN) != (int) c)
    error_fatal("ungetc getplist", NULL);

  /* read */
  bufsize = BUFSIZE;
  if ((buf = (char *) malloc(bufsize*sizeof(char))) == NULL)
    error_fatal ("memory" , NULL);

  pat_init(p);

  while (fgets(buf, bufsize, IN) != NULL) {
    /* Check for full line */
    if ((ebuf = strrchr(buf, '\n')) != NULL) { break; }
    if (feof(IN) != 0) { break; }
    /* Redo with larger buffer ... */
    bufsize += BUFSIZE;
    if ((buf = (char *) realloc(buf, bufsize*sizeof(char))) == NULL)
      error_fatal("memory", NULL);
    if (fseek(IN, (long) -strlen(buf), SEEK_CUR) != 0)
      error_fatal ("file", NULL);
  }
  if (ebuf)
    *ebuf = '\0';

  /* stockage */
  isbuf = buf;
  while( *isbuf && isspace(*isbuf) ) isbuf++;

  if ( (iebuf =  strpbrk(isbuf, "\t ")) != NULL ) {
    /* have an id for the pattern */
    plen = iebuf - isbuf;
    if ((p->ac = (char *) malloc((plen+1)*sizeof(char))) == NULL)
      error_fatal("memory", NULL);
    (void) strncpy(p->ac, isbuf, (size_t) plen);
    *(p->ac+plen) = '\0';

    /* skip separation blanks */
    while( *iebuf && isspace(*iebuf) ) iebuf++;
    isbuf = iebuf;
  }

  if ( *isbuf ) {
    plen = strlen(isbuf);
    if ((p->pat = (char *) malloc((plen+1)*sizeof(char))) == NULL)
      error_fatal("memory", NULL);
    (void) strncpy(p->pat, isbuf, (size_t) plen);
    *(p->pat+plen) = '\0';
  }
  else {
    /* delimiters at the end, so pat = id */
    p->pat = p->ac;
    p->ac = NULL;
  }

  free (buf);
  if ( p->pat == NULL) return ERR;
  return OK;
}

void pat_init (pat_t *p) {
  p->pat = p->id = p->ac = p->acdoc = p->desc = NULL;
}
