#! /bin/sh

## Verbose mode
test "x$VERBOSE" = xx && set -x

pat1='[LIVMFY](3)-x-G-[DEQ]-[STE]-G-[STAV]-G-K-x(2)-[LIVMFY]'
pat2='[livmfy](3)-x-g-[deq]-[ste]-g-[stav]-g-k-x(2)-[livmfy]'

seq1='IIVIGDSGTGKSSL'
seq2='iivigdsgtgkssl'

## Check case-insensitive search
for s in $seq1 $seq2; do
  (echo ">seq"; echo $s) >_fasta.seq
  for p in $pat1 $pat2; do
    ../src/prose -p $p _fasta.seq | grep -q '^seq' || exit 1
  done
done

## Check case-sensitive search
(echo ">seq"; echo $seq1) >_fasta.seq
../src/prose -c -p $pat1 _fasta.seq | grep -q '^seq' || exit 1
../src/prose -c -p $pat2 _fasta.seq | grep -q '^seq' && exit 1
(echo ">seq"; echo $seq2) >_fasta.seq
../src/prose -c -p $pat1 _fasta.seq | grep -q '^seq' && exit 1
../src/prose -c -p $pat2 _fasta.seq | grep -q '^seq' || exit 1

## Cleanup
rm -f _fasta.seq

exit 0
