/* megal.l - MEGA alignment lexer */

%{
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif

#include "align/megay.h"

#undef  YY_DECL
#define YY_DECL int yylex(YYSTYPE *yylval)

static int init = 0;
%}

%option caseless
%option never-interactive
%option nounput noyywrap

%x HDRTAG DEFTAG NAMTAG SEQTAG
%x DEFTA2

alp        [[:alpha:]]
exc        "!"
die        "#"
eol        "\n"
min        "-"
que        "?"
sem        ";"
spc        " "
sta        "*"

txt        .{1,80}

tag        mega
key        [^!; \n]{1,20}
nam        [^ \n]{1,40}
gap        ({min}|{que})
bas        ({alp}|{gap}|{sta}){1,10}

%%

^{eol}         ; /* Empty lines ignored */

^{die}/{tag}   { BEGIN HDRTAG; return DIE; }
<HDRTAG>{tag}  { return TAG; }
<HDRTAG>{eol}  { BEGIN INITIAL; return EOL; }
<HDRTAG>.      { return ERR; }

^{exc}         { BEGIN DEFTAG; return EXC; }
<DEFTAG>{key}  { return KEY; }
<DEFTAG>{spc}  { BEGIN DEFTA2; }
<DEFTAG>{sem}  { BEGIN DEFTA2; return SEM; }
<DEFTAG>{eol}/{spc} { BEGIN DEFTA2; } /* Line continuation ignored */
<DEFTAG>{eol}  { return ERR; }
<DEFTAG>.      { return ERR; }

<DEFTA2>{txt}/{sem}{eol} { return TXT; }
<DEFTA2>{txt}/{eol}{spc} { return TXT; }
<DEFTA2>{sem}  { return SEM; }
<DEFTA2>{eol}/{spc} /* Line continuation ignored */
<DEFTA2>{eol}  { BEGIN INITIAL; return EOL; }
<DEFTA2>.      { return ERR; }

^{die}         { BEGIN NAMTAG; return DIE; }
<NAMTAG>{nam}  { yylval->str = strdup(yytext); return NAM; }
<NAMTAG>{spc}  { BEGIN SEQTAG; return EOL; }
<NAMTAG>{eol}  { BEGIN SEQTAG; return EOL; }
<NAMTAG>.      { return ERR; }

<SEQTAG>{bas}  { yylval->str = strdup(yytext); return BAS; }
<SEQTAG>{spc}  ; /* Spaces ignored */
<SEQTAG>{eol}  ; /* Newlines ignored */
<SEQTAG>{eol}/{die} { BEGIN INITIAL; return EOL; }
<SEQTAG><<EOF>> { BEGIN INITIAL; return EOL; }
<SEQTAG>.      { return ERR; }

{eol}          { return ERR; }
.              { return ERR; }

%%
