/* parse.c - Alignment parsing helper functions */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif
#include <ctype.h>

#include "align.h"
#include "align/parse.h"
#include "sequence.h"
#include "sequence/parse.h"
#include "extern/error.h"


/* Add new sequence ... */
int parse_seqadd(align_t *ali, char *nam) {
  char *q, *r;
  int i;
  size_t len;
  sequence_t **p;

  if (nam == NULL) { return 0; }
  if (ali == NULL) { free(nam); return 0; }

  /* Cleanup leading spaces */
  q = nam; while (*q && isspace((unsigned char)*q)) { q++; }
  if (q != nam) { r = strdup(q); free(nam); nam = r; }

  /* Search if sequence already exist */
  p = ali->cur;
  if (p && *p) {
    if (strcmp((*p)->nam, nam) != 0) {
      error_fatal(nam, "unexpected sequence name"); }
    free(nam);
    return 0; }

  /* Check for reallocation */
  p = ali->seq; i = 0; while (p && *p) { i++; p++; }
  len = sizeof(sequence_t *) * (i + 1 + 1);
  if ((ali->seq = realloc(ali->seq, len)) == NULL) {
    error_fatal("memory", NULL); }

  /* Add new sequence & NULL byte */
  p = ali->seq + i;
  *p = sequence_new();
  (*p)->nam = nam;
  *(p+1) = NULL;

  /* Set current sequence */
  ali->cur = p;

  return 0; }


/* Update sequence string */
int parse_sequpd(align_t *ali, char *str) {
  sequence_t **p;

  if (str == NULL) { return 0; }
  if (ali == NULL) { free(str); return 0; }

  p = ali->cur;
  if (*p == NULL) { return -1; }
  parse_stradd(*p, str);

  return 0; }


/* Set current sequence pointer at the begginning */
int parse_seqrst(align_t *ali) {

  if (ali == NULL || ali->seq == NULL) { return 0; }

  if (*ali->cur != NULL && ali->cur != ali->seq) { return -1; }
  ali->cur = ali->seq;

  return 0; }


/* Update current sequence pointer to the next one */
int parse_seqnxt(align_t *ali) {

  if (ali == NULL || ali->seq == NULL) { return 0; }

  if (*ali->cur == NULL) { return -1; }
  ali->cur += 1;

  return 0; }
