/* phylip.c - PHYLIP common alignment functions */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif

#include "align.h"
#include "align/phylip.h"
#include "extern/error.h"


/* Fix bad sequence names */
char **phylip_addfixnames(char **nam, align_t *ali) {
  char **p, *q;
  size_t n, len;
  sequence_t **s;

  s = ali->seq; n = 0;
  while (s && *s) { n++; s++; }

  len = n * sizeof(char **);
  if ((nam = (char **)realloc(nam, len)) == NULL) {
    error_fatal("memory", NULL); }

  s = ali->seq; p = nam;
  while (s && *s) {
    *p = (*s)->nam;
    /* Truncate names to 10 characters if needed */
    if (strlen((*s)->nam) > 10) {
      *p = strdup((*s)->nam); q = *p; *(q+10) = '\0'; }
    /* Check/Fix invalid characters */
    q = *p;
    while (q && *q) {
      if (strchr("():;,[]", *q) != NULL) { *q = '_'; }
      q++; }
    p++; s++; }

  return nam; }

int phylip_delfixnames(char **nam, align_t *ali) {
  char **p;
  sequence_t **s;

  s = ali->seq; p = nam;
  while (s && *s) {
    if (*p != (*s)->nam) { free(*p); }
    p++; s++; }

  free(nam);

  return 0; }
