/* phylipiy.y - PHYLIPI alignment parser */

%{
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
#endif

#include "align.h"
#include "align/parse.h"
#include "align/phylipiy.h"

#define YYPARSE_PARAM ali

int yylex(YYSTYPE *);
static void yyerror(const char *);

int phylipiy_check(FILE *);
align_t *phylipiy_parse(FILE *);
%}

%pure-parser

%union { char *str; }

%token EOL ERR INT SPC
%token <str> NAM BAS

%%

phylipi : header nament seqents ;

header : numline ;
numline : INT SPC INT EOL ;

nament : nament namline               { CHKERR(parse_seqnxt((align_t *)ali)); }
       | namline                      { CHKERR(parse_seqnxt((align_t *)ali)); }
       ;
namline : namval seqlist EOL ;
namval : NAM                      { CHKERR(parse_seqadd((align_t *)ali, $1)); }
       ;

seqents : seqents seqent
        | /* Empty */
        ;
seqent : seqent seqline               { CHKERR(parse_seqnxt((align_t *)ali)); }
       | EOL                          { CHKERR(parse_seqrst((align_t *)ali)); }
       ;
seqline : seqlist EOL ;

seqlist : seqlist BAS             { CHKERR(parse_sequpd((align_t *)ali, $2)); }
        | BAS                     { CHKERR(parse_sequpd((align_t *)ali, $1)); }
        ;

%%


/* Checks PHYLIPI sequence */
int phylipiy_check(FILE *f) {
  extern FILE *phylipiin;
  int i;

  phylipiin = f;
  i = yyparse(NULL);

  return i; }


/* Parse PHYLIPI alignment */
align_t *phylipiy_parse(FILE *f) {
  extern FILE *phylipiin;
  int i;
  align_t *ali;

  if ((ali = align_new()) == NULL) {
    return NULL; }

  phylipiin = f;
  i = yyparse((void *)ali);
  if (i == 0 && ali->seq != NULL) {
    return ali; }

  return NULL; }


/* Helpers ... */

/*ARGSUSED*/
static void yyerror(const char *s) { return; }
