/* stocky.y - STOCKHOLM alignment parser */

%{
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
#endif

#include "align.h"
#include "align/parse.h"
#include "align/stocky.h"

#define YYPARSE_PARAM ali

int yylex(YYSTYPE *);
static void yyerror(const char *);

int stocky_check(FILE *);
align_t *stocky_parse(FILE *);
%}

%pure-parser

%union { char *str; }

%token DOT EOL ERR INT SPC
%token TAG END
%token <str> NAM BAS

%%

stock : header seqents end ;

header : hdrtag SPC hdrver EOL ;
hdrtag : TAG ;
hdrver : INT DOT INT ;

seqents : seqents seqent | seqent ;

seqent : seqent seqline               { CHKERR(parse_seqnxt((align_t *)ali)); }
       | EOL                          { CHKERR(parse_seqrst((align_t *)ali)); }
       ;

seqline : seqnam SPC seqbas EOL ;

seqnam : NAM                      { CHKERR(parse_seqadd((align_t *)ali, $1)); }
       ;
seqbas : seqbas BAS               { CHKERR(parse_sequpd((align_t *)ali, $2)); }
       | BAS                      { CHKERR(parse_sequpd((align_t *)ali, $1)); }
       ;

end : END EOL ;

%%


/* Checks STOCK sequence */
int stocky_check(FILE *f) {
  extern FILE *stockin;
  int i;

  stockin = f;
  i = yyparse(NULL);

  return i; }


/* Parse STOCK alignment */
align_t *stocky_parse(FILE *f) {
  extern FILE *stockin;
  int i;
  align_t *ali;

  if ((ali = align_new()) == NULL) {
    return NULL; }

  stockin = f;
  i = yyparse((void *)ali);
  if (i == 0 && ali->seq != NULL) {
    return ali; }

  return NULL; }


/* Helpers ... */

/*ARGSUSED*/
static void yyerror(const char *s) { return; }
