/* -----------------------------------------------------------------
 file      : /home/schuerer/toppred/src/mloutput.c

 author    : Schuerer <schuerer@pasteur.fr>
 creation  : <Tue Oct  2 13:02:00 2001>
 Time-stamp: <Mon Apr 14 15:34:28 2003>
 Dev-stage : distrib

 description :


-------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "error.h"
#include "config.h"
#include "usage.h"

#include "output.h"
#include "mloutput.h"

/* internal macros */

/* internal prototypes */

void xml_header(FILE *OUT, char *data_dir) {

  (void) fprintf (OUT, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
  (void) fprintf (OUT, "<!DOCTYPE toppred SYSTEM \"toppred.dtd\">\n");
  (void) fprintf (OUT, "\n<toppreds>\n");

}

void xml_tail(FILE *OUT) {
  (void) fprintf (OUT, "\n</toppreds>\n");
}

void xml_parameters (param_t *p) {

  FILE *OUT = p->OUT;
  char *scale;

  scale = basename(p->data_file);

  (void) fprintf(OUT, "\n<parameters>\n");

  (void) fprintf(OUT, "<corewindow>%d</corewindow>\n", p->n);
  (void) fprintf(OUT, "<wedgewindow>%d</wedgewindow>\n", p->q);
  (void) fprintf(OUT, "<certain>%.2f</certain>\n", p->c_cut);
  (void) fprintf(OUT, "<putative>%.2f</putative>\n", p->p_cut);
  (void) fprintf(OUT, "<distsegments>%d</distsegments>\n", p->tmspacer);
  (void) fprintf(OUT, "<looplength>%d</looplength>\n", p->seg_len);
  (void) fprintf(OUT, "<kingdom>%s</kingdom>\n",
		 (p->kingdom == EUKARYOTE) ? "eucaryote" : "procaryote");
  (void) fprintf(OUT, "<hydrophobycity>%s</hydrophobycity>\n", scale);
  (void) fprintf(OUT, "</parameters>\n");
}

void xml_header_sequence(FILE *OUT, seq_t *seq) {

  (void) fprintf(OUT, "\n<toppred> ");
  (void) fprintf(OUT, "\n  <sequence ");
  (void) fprintf(OUT, "id=\"%s\" ", seq->id);
  (void) fprintf(OUT, "size=\"%d\">\n", seq->size);

  print_sequence(OUT, seq->seq);
  (void) fprintf(OUT, "  </sequence>\n");

}

void xml_tail_sequence(FILE *OUT) {
  (void) fprintf(OUT, "</toppred>\n");
}

void xml_plot (FILE *OUT, char *seqname, param_t *p) {

  (void) fprintf (OUT, "\n  <plot hydro=\"%s.hydro\"", seqname);
#ifdef HAVE_GNUPLOT
  if (p->gplot && p->plot_outfile) {
      (void) fprintf (OUT, " gplot=\"%s.%s\"", seqname, p->plot_outfile);
  }
#endif
  (void) fprintf (OUT, "/>\n");

}


void xml_tmsummary (FILE *OUT, int nseg, seg_t *KSseg) {

  int i;

  if (nseg) {
    (void) fprintf(OUT, "\n  <tmsummary segments=\"%d\" len=\"%d\">\n",
		   nseg, KSseg->stop - KSseg->start);
    for (i=0; i<nseg; i++) {
      (void) fprintf(OUT, "  <segment ");
      (void) fprintf(OUT, "start=\"%d\" ",  KSseg[i].start+1);
      (void) fprintf(OUT, "stop=\"%d\" ",   KSseg[i].stop);
      (void) fprintf(OUT, "hp=\"%.3f\" ",   KSseg[i].H);
      (void) fprintf(OUT, "type=\"%s\"/>\n",
		     (KSseg[i].kind == 0) ? "putative" : "certain");
    }
    (void) fprintf(OUT, "  </tmsummary>\n");
  }
  else { (void) fprintf(OUT, "\n  <tmsummary segments=\"0\">\n  </tmsummary>\n"); }
}

#define xml_typeloop(type) (strcmp(type, "LOOP_EXT") == 0) ? "ext" : (strcmp(type, "LOOP_CYT") == 0) ? "cyt" : "unknown"

void xml_topology(topoprint_t *topo, int nel, param_t *para) {

  FILE *OUT = para->OUT;
  int clen = para->seg_len;
  elprint_t *el = topo->elps;
  int i;

  /* header */
  (void) fprintf (OUT, "\n  <topology nr=\"%d\" ", topo->nr);
  (void) fprintf (OUT, "prob=\"%.2f\" ", topo->prob);
  (void) fprintf (OUT, "darglys=\"%.2f\" ", (double) topo->kr);
  (void) fprintf (OUT, "dcytext=\"%.2f\" ", topo->cytext);
  (void) fprintf (OUT, "dncharge=\"%.2f\" ", (double) topo->nterm);
  (void) fprintf (OUT, "dnnegpos=\"%.2f\"", topo->negpos);
#ifdef  HAVE_LIBGD
  if (topo->image != NULL) {
	(void) fprintf (OUT, " image=\"%s\"", topo->image);
  }
#endif
 (void) fprintf (OUT, " orient=\"%s %s %s\">\n",
		 new_orientation((double) (topo->kr+topo->ncharge)),
		 new_orientation(topo->cytext * (-1.0)),
		 new_orientation((double) topo->nterm));


  /* topo elements */
  for (i=0; i<nel; i++) {
    if (i%2) { /* tmsegment (index impair) */
      (void) fprintf(OUT, "   <tmsegment ");
      (void) fprintf(OUT, "start=\"%d\" ", el[i].tm.start+1);
      (void) fprintf(OUT, "stop=\"%d\" ", el[i].tm.stop);
      /* (void) fprintf(OUT, "len=\"%d\" ", el[i].tm.len); */
      (void) fprintf(OUT, "prob=\"%.2f\" ", (double)el[i].tm.len);
      (void) fprintf(OUT, "hp=\"%.2f\"/>\n", el[i].tm.H);
    }
    else if (i > 0 || el[i].lo.start != -1) { /* loop (index pair) existant */
      (void) fprintf(OUT, "   <loop type=\"%s\" ", xml_typeloop(el[i].lo.type));
      (void) fprintf(OUT, "start=\"%d\" ", el[i].lo.start+1);
      (void) fprintf(OUT, "stop=\"%d\" ", el[i].lo.stop);
      /* (void) fprintf(OUT, "len=\"%d\" ", el[i].lo.len); */
      (void) fprintf(OUT, "darglys=\"%.2f\" ", (double) el[i].lo.kr);
      (void) fprintf(OUT, "dcytext=\"%.2f\" ", el[i].lo.cytext);
      (void) fprintf(OUT, "decisive=\"%s\"/>\n",
		     (el[i].lo.len > clen) ? "dcytext" : "darglys");
    }
  }

  /* end topology */
  (void) fprintf(OUT, "  </topology>\n");
}

FILE *init_html(char *name, char *dir) {

  char *filename;
  FILE *OUT;
  int len;

  len = strlen(name) + strlen(dir) + 5 + 1;
  /* open file */
  if ((filename =  malloc((size_t)len)) == NULL){
    error_fatal("html output file", NULL);
  }

  (void)sprintf(filename, "%s%s.html",dir, name);

  if ((OUT = fopen(filename, "w")) == NULL){
    error_fatal(filename, NULL);
  }

  free(filename);

  return OUT;
}

void html_header (FILE *OUT, char *name) {

  (void)fprintf(OUT, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\n\"");
  (void)fprintf(OUT, "\"http://www.w3.org/TR/REC-html40/strict.dtd\">\n");
  (void)fprintf(OUT, "<HTML>\n");

  (void)fprintf(OUT, "<HEAD>\n");
  (void)fprintf(OUT, "<META http-equiv=\"Content-Type\"content=\"text/html;");
  (void)fprintf(OUT, "charset=iso-8859-1\">\n");
  (void)fprintf(OUT, "<TITLE>Toppred prediction %s</TITLE>\n", name);
  (void)fprintf(OUT, "</HEAD>\n");

  (void)fprintf(OUT, "<BODY>\n");
   (void)fprintf(OUT, "<H1><CENTER>Toppred prediction %s</CENTER></H1>\n", name);
  (void)fprintf(OUT, "<PRE>\n");

}

void html_parameters (FILE *OUT, param_t *p) {

  (void) fprintf (OUT, "<H4><CENTER>Algorithm specific parameters</CENTER></H4>\n\n");
  (void) fprintf (OUT, "<PRE>\n");
  new_print_parameters (p);
  (void) fprintf (OUT, "</PRE>\n");

}

void html_sequence (FILE *OUT, seq_t *seq) {

  (void)fprintf(OUT, "<H4><CENTER>Sequence</CENTER></H4>\n");
  start_phrase();
  (void) fprintf(OUT, "Sequence : %s  (%d res)\n", seq->id, seq->size);
  print_sequence(OUT, seq->seq);
  end_phrase();

}

void html_plot (FILE *OUT, char *seqname, param_t *p) {

  (void)fprintf(OUT, "<H4><CENTER>Hydrophobicity plot</CENTER></H4>\n");
  (void)fprintf(OUT, "<P><CENTER>\n");
#ifdef HAVE_GNUPLOT
  if (p->gplot && p->plot_outfile && !strcmp(p->plot_outfile, PNG)) {
    (void)fprintf(OUT, "<IMG SRC=\"./%s.png\">\n", seqname);
  }
#endif
  (void)fprintf(OUT, "<PRE>\n");
  (void)fprintf(OUT, "<P>\n");
  (void)fprintf(OUT, "<A HREF=\"./%s.hydro\">view hydrophobic values</A>\n",
		seqname);
  (void)fprintf(OUT, "</P>\n");
  (void)fprintf(OUT, "</CENTER></P>\n");

}

void html_topology (topoprint_t *topo, int nel, param_t *para) {

  FILE *OUT = para->OUT;
  int clen = para->seg_len;
  elprint_t *el = topo->elps;
  int i;

  /* header */
  (void) fprintf (OUT, "%8s %6s %6s %6s %4s %4s %8s %8s %8s %8s\n",
		  "HEADER  ", "START", "STOP", "LEN",
		  "PROB", "HP",
		  "DARGLYS", "DCYTEXT",  "DNCHARGE", "DNNEGPOS");


  /* topo summary */
  (void) fprintf (OUT, "%8s ", "TOPOLOGY");
#ifdef  HAVE_LIBGD
  if (!strcmp(para->topo_format, PNG)) {
    (void) fprintf (OUT, "<A HREF=\"./%s\">%3d</A>", topo->image, topo->nr);
  }
  else {
    (void) fprintf (OUT, "%3d", topo->nr);
  }
#else
  (void) fprintf (OUT, "%3d", topo->nr);
#endif

  (void) fprintf (OUT, "                  %3.2f       %6.2f   %6.2f  %8.2f %8.2f\n",
		  topo->prob, (double) topo->kr,
		  topo->cytext, (double) topo->nterm, topo->negpos);

  (void) fprintf (OUT, "%8s                                %7s  %7s  %8s\n",
		  "TOPOLOGY",
  		  new_orientation((double) (topo->kr+topo->ncharge)),
  		  new_orientation(topo->cytext * (-1.0)),
		  new_orientation((double) topo->nterm));

  /* topo elements */
  for (i=0; i<nel; i++) {
      if (i%2) { /* tmsegment (index impair) */
	(void) fprintf(OUT, "%8s %6d %6d %6d %4.2f %4.2f\n",
		       el[i].tm.type, el[i].tm.start+1, el[i].tm.stop,
		       el[i].tm.len, el[i].tm.prob, el[i].tm.H);
      }
      else { /* loop (index pair) */
	if (el[i].lo.len > clen) { /* cytext value is significant */
	  (void) fprintf(OUT, "%8s %6d %6d %6d           (%6.2f)  %6.2f\n",
			 el[i].lo.type, el[i].lo.start+1, el[i].lo.stop,
			 el[i].lo.len, (double) el[i].lo.kr, el[i].lo.cytext);
	}
	else if (el[i].lo.len != 0) { /* kr value is significant */
	  (void) fprintf(OUT, "%8s %6d %6d %6d            %6.2f  (%6.2f)\n",
			 el[i].lo.type, el[i].lo.start+1, el[i].lo.stop,
			 el[i].lo.len, (double) el[i].lo.kr, el[i].lo.cytext);
	}
      }
  }

  (void) fprintf(OUT, "\n");

  return;
}
